/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class AddStaticVariableOnProducerSessionBean
extends ScanningRecipe<Set<String>> {
    private static final XPathMatcher EJB_PATH = new XPathMatcher("ejb-jar/enterprise-beans/session");

    public String getDisplayName() {
        return "Adds `static` modifier to `@Produces` fields that are in session beans";
    }

    public String getDescription() {
        return "Ensures that the fields annotated with `@Produces` which is inside the session bean (`@Stateless`, `@Stateful`, or `@Singleton`) are declared `static`.";
    }

    public Set<String> getInitialValue(ExecutionContext ctx) {
        return new HashSet<String>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Set<String> acc) {
        return Preconditions.check((Recipe)new FindSourceFiles("**/ejb-jar.xml"), (TreeVisitor)new XmlVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (EJB_PATH.matches(this.getCursor())) {
                    Xml.Tag ejbClassTag = tag.getChild("ejb-class").orElse(null);
                    Xml.Tag sessionTag = tag.getChild("session-type").orElse(null);
                    if (ejbClassTag != null && sessionTag != null) {
                        String className = ejbClassTag.getValue().orElse(null);
                        String sessionType = sessionTag.getValue().orElse(null);
                        if (className != null && ("Singleton".equalsIgnoreCase(sessionType) || "Stateless".equalsIgnoreCase(sessionType) || "Stateful".equalsIgnoreCase(sessionType))) {
                            acc.add(className);
                        }
                    }
                }
                return super.visitTag(tag, (Object)ctx);
            }
        });
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Set<String> acc) {
        return Preconditions.check((TreeVisitor)new UsesType("jakarta.enterprise.inject.Produces", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (!multiVariable.hasModifier(J.Modifier.Type.Static) && this.hasAnnotation((J)multiVariable, "@jakarta.enterprise.inject.Produces") && (this.isInSessionBean() || this.isInXml())) {
                    return multiVariable.withModifiers(ListUtils.concat((List)multiVariable.getModifiers(), (Object)new J.Modifier(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, null, J.Modifier.Type.Static, Collections.emptyList())));
                }
                return multiVariable;
            }

            private boolean isInSessionBean() {
                J.ClassDeclaration parentClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (parentClass == null) {
                    return false;
                }
                return this.hasAnnotation((J)parentClass, "@jakarta.ejb.Singleton") || this.hasAnnotation((J)parentClass, "@jakarta.ejb.Stateful") || this.hasAnnotation((J)parentClass, "@jakarta.ejb.Stateless");
            }

            private boolean isInXml() {
                J.ClassDeclaration parentClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (parentClass != null && parentClass.getType() != null) {
                    return acc.contains(parentClass.getType().getFullyQualifiedName());
                }
                return false;
            }

            private boolean hasAnnotation(J j, String annotationPattern) {
                return !FindAnnotations.find((J)j, (String)annotationPattern).isEmpty();
            }
        });
    }
}

