/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.migrate.ChangeMethodInvocationReturnType;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;

public final class ReplaceAWTGetPeerMethod
extends Recipe {
    @Option(displayName="Method pattern to replace", description="The method pattern to match and replace.", example="java.awt.* getPeer()", required=false)
    private final String getPeerMethodPattern;
    @Option(displayName="The LightweightPeer interface FQCN", description="The fully qualified class name of the LightweightPeer interface to replace in `instanceof`.", example="java.awt.peer.LightweightPeer", required=false)
    private final String lightweightPeerFQCN;

    @JsonCreator
    public ReplaceAWTGetPeerMethod() {
        this.getPeerMethodPattern = "java.awt.* getPeer()";
        this.lightweightPeerFQCN = "java.awt.peer.LightweightPeer";
    }

    public String getDisplayName() {
        return "Replace AWT `getPeer()` method";
    }

    public String getDescription() {
        return "This recipe replaces the use of `getPeer()` method in `java.awt.*` classes. `component.getPeer() != null` is replaced with `component.isDisplayable()` and `component.getPeer() instanceof LightweightPeer` is replaced with `component.isLightweight()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcherGetPeer = new MethodMatcher(this.getPeerMethodPattern);
        return Preconditions.check((TreeVisitor)new UsesMethod(methodMatcherGetPeer), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                J.Binary bi = (J.Binary)super.visitBinary(binary, (Object)ctx);
                J.MethodInvocation mi = this.findMatchingMethodInvocation(bi);
                if (mi != null) {
                    mi = (J.MethodInvocation)new ChangeMethodName(ReplaceAWTGetPeerMethod.this.getPeerMethodPattern, "isDisplayable", Boolean.valueOf(true), null).getVisitor().visit((Tree)mi, (Object)ctx);
                    mi = (J.MethodInvocation)new ChangeMethodInvocationReturnType(ReplaceAWTGetPeerMethod.this.getPeerMethodPattern.split(" ")[0] + " isDisplayable()", "boolean").getVisitor().visit((Tree)mi, (Object)ctx);
                    assert (mi != null);
                    return mi.withPrefix(bi.getPrefix());
                }
                return bi;
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.MethodInvocation findMatchingMethodInvocation(J.Binary binaryCondition) {
                J.MethodInvocation mi = null;
                if (binaryCondition.getOperator() == J.Binary.Type.NotEqual) {
                    if (binaryCondition.getLeft() instanceof J.MethodInvocation && binaryCondition.getRight() instanceof J.Literal) {
                        mi = (J.MethodInvocation)binaryCondition.getLeft();
                    } else if (binaryCondition.getLeft() instanceof J.Literal && binaryCondition.getRight() instanceof J.MethodInvocation) {
                        mi = (J.MethodInvocation)binaryCondition.getRight();
                    }
                }
                if (methodMatcherGetPeer.matches(mi)) {
                    return mi;
                }
                return null;
            }

            public J visitInstanceOf(J.InstanceOf instOf, ExecutionContext ctx) {
                J.MethodInvocation mi;
                J.InstanceOf instanceOfVar = (J.InstanceOf)super.visitInstanceOf(instOf, (Object)ctx);
                if (instanceOfVar.getExpression() instanceof J.MethodInvocation && methodMatcherGetPeer.matches((MethodCall)(mi = (J.MethodInvocation)instanceOfVar.getExpression())) && TypeUtils.isAssignableTo((String)ReplaceAWTGetPeerMethod.this.lightweightPeerFQCN, (JavaType)((TypedTree)instanceOfVar.getClazz()).getType())) {
                    mi = (J.MethodInvocation)new ChangeMethodName(ReplaceAWTGetPeerMethod.this.getPeerMethodPattern, "isLightweight", Boolean.valueOf(true), null).getVisitor().visit((Tree)mi, (Object)ctx);
                    mi = (J.MethodInvocation)new ChangeMethodInvocationReturnType(ReplaceAWTGetPeerMethod.this.getPeerMethodPattern.split(" ")[0] + " isLightweight()", "boolean").getVisitor().visit((Tree)mi, (Object)ctx);
                    assert (mi != null);
                    this.maybeRemoveImport(ReplaceAWTGetPeerMethod.this.lightweightPeerFQCN);
                    return mi.withPrefix(instanceOfVar.getPrefix());
                }
                return instanceOfVar;
            }
        });
    }

    @Generated
    public String getGetPeerMethodPattern() {
        return this.getPeerMethodPattern;
    }

    @Generated
    public String getLightweightPeerFQCN() {
        return this.lightweightPeerFQCN;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceAWTGetPeerMethod(getPeerMethodPattern=" + this.getGetPeerMethodPattern() + ", lightweightPeerFQCN=" + this.getLightweightPeerFQCN() + ")";
    }

    @ConstructorProperties(value={"getPeerMethodPattern", "lightweightPeerFQCN"})
    @Generated
    public ReplaceAWTGetPeerMethod(String getPeerMethodPattern, String lightweightPeerFQCN) {
        this.getPeerMethodPattern = getPeerMethodPattern;
        this.lightweightPeerFQCN = lightweightPeerFQCN;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceAWTGetPeerMethod)) {
            return false;
        }
        ReplaceAWTGetPeerMethod other = (ReplaceAWTGetPeerMethod)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$getPeerMethodPattern = this.getGetPeerMethodPattern();
        String other$getPeerMethodPattern = other.getGetPeerMethodPattern();
        if (this$getPeerMethodPattern == null ? other$getPeerMethodPattern != null : !this$getPeerMethodPattern.equals(other$getPeerMethodPattern)) {
            return false;
        }
        String this$lightweightPeerFQCN = this.getLightweightPeerFQCN();
        String other$lightweightPeerFQCN = other.getLightweightPeerFQCN();
        return !(this$lightweightPeerFQCN == null ? other$lightweightPeerFQCN != null : !this$lightweightPeerFQCN.equals(other$lightweightPeerFQCN));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ReplaceAWTGetPeerMethod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $getPeerMethodPattern = this.getGetPeerMethodPattern();
        result = result * 59 + ($getPeerMethodPattern == null ? 43 : $getPeerMethodPattern.hashCode());
        String $lightweightPeerFQCN = this.getLightweightPeerFQCN();
        result = result * 59 + ($lightweightPeerFQCN == null ? 43 : $lightweightPeerFQCN.hashCode());
        return result;
    }
}

