/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public final class MigrateStringReaderToReaderOf
extends Recipe {
    private static final MethodMatcher STRING_READER_CONSTRUCTOR = new MethodMatcher("java.io.StringReader <constructor>(java.lang.String)");
    private static final MethodMatcher TO_STRING_METHOD = new MethodMatcher("java.lang.Object toString()", true);

    public String getDisplayName() {
        return "Use `Reader.of(CharSequence)` for non-synchronized readers";
    }

    public String getDescription() {
        return "Migrate `new StringReader(String)` to `Reader.of(CharSequence)` in Java 25+. This only applies when assigning to `Reader` variables or returning from methods that return `Reader`. The new method creates non-synchronized readers which are more efficient when thread-safety is not required.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(25), new UsesMethod(STRING_READER_CONSTRUCTOR)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitVariableDeclarations(J.VariableDeclarations mV, ExecutionContext ctx) {
                if (TypeUtils.isOfClassType((JavaType)mV.getTypeAsFullyQualified(), (String)"java.io.Reader")) {
                    return mV.withVariables(ListUtils.map((List)mV.getVariables(), v -> {
                        this.maybeRemoveImport("java.io.StringReader");
                        this.maybeAddImport("java.io.Reader");
                        return (J.VariableDeclarations.NamedVariable)new TransformVisitor().visitNonNull((Tree)v, ctx, this.getCursor().getParentOrThrow());
                    }));
                }
                return super.visitVariableDeclarations(mV, (Object)ctx);
            }

            public J visitAssignment(J.Assignment a, ExecutionContext ctx) {
                J.Identifier variable;
                if (a.getVariable() instanceof J.Identifier && TypeUtils.isOfClassType((JavaType)(variable = (J.Identifier)a.getVariable()).getType(), (String)"java.io.Reader")) {
                    this.maybeRemoveImport("java.io.StringReader");
                    this.maybeAddImport("java.io.Reader");
                    return (J)new TransformVisitor().visitNonNull((Tree)a, ctx, this.getCursor().getParentOrThrow());
                }
                return super.visitAssignment(a, (Object)ctx);
            }

            public J visitReturn(J.Return r, ExecutionContext ctx) {
                JavaType returnType;
                J.MethodDeclaration method = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                if (method != null && method.getReturnTypeExpression() != null && TypeUtils.isOfClassType((JavaType)(returnType = method.getReturnTypeExpression().getType()), (String)"java.io.Reader")) {
                    this.maybeRemoveImport("java.io.StringReader");
                    this.maybeAddImport("java.io.Reader");
                    return (J)new TransformVisitor().visitNonNull((Tree)r, ctx, this.getCursor().getParentOrThrow());
                }
                return super.visitReturn(r, (Object)ctx);
            }
        });
    }

    @Generated
    public MigrateStringReaderToReaderOf() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "MigrateStringReaderToReaderOf()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateStringReaderToReaderOf)) {
            return false;
        }
        MigrateStringReaderToReaderOf other = (MigrateStringReaderToReaderOf)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MigrateStringReaderToReaderOf;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class TransformVisitor
    extends JavaVisitor<ExecutionContext> {
        private TransformVisitor() {
        }

        public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            if (STRING_READER_CONSTRUCTOR.matches((MethodCall)newClass)) {
                return JavaTemplate.builder((String)"Reader.of(#{any(java.lang.CharSequence)})").imports(new String[]{"java.io.Reader"}).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{this.optimizeCharSequenceToString((Expression)newClass.getArguments().get(0))});
            }
            return super.visitNewClass(newClass, (Object)ctx);
        }

        private Expression optimizeCharSequenceToString(Expression expr) {
            if (expr instanceof J.MethodInvocation) {
                J.MethodInvocation mi = (J.MethodInvocation)expr;
                if (TO_STRING_METHOD.matches((MethodCall)mi) && mi.getSelect() != null && TypeUtils.isAssignableTo((String)"java.lang.CharSequence", (JavaType)mi.getSelect().getType())) {
                    return mi.getSelect();
                }
            }
            return expr;
        }
    }
}

