/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.VariableReferences;

public class MigrateMainMethodToInstanceMain
extends Recipe {
    public String getDisplayName() {
        return "Migrate `public static void main(String[] args)` to instance `void main()`";
    }

    public String getDescription() {
        return "Migrate `public static void main(String[] args)` method to instance `void main()` method when the `args` parameter is unused, as supported by JEP 512 in Java 25+.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(25), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                if (!("main".equals(md.getSimpleName()) && md.getReturnTypeExpression() != null && md.getReturnTypeExpression().getType() == JavaType.Primitive.Void && md.hasModifier(J.Modifier.Type.Public) && md.hasModifier(J.Modifier.Type.Static) && md.getParameters().size() == 1 && md.getParameters().get(0) instanceof J.VariableDeclarations && md.getBody() != null)) {
                    return md;
                }
                J.VariableDeclarations param = (J.VariableDeclarations)md.getParameters().get(0);
                JavaType paramType = param.getType();
                if (!TypeUtils.isOfClassType((JavaType)paramType, (String)"java.lang.String") || !(paramType instanceof JavaType.Array)) {
                    return md;
                }
                J.Identifier variableName = ((J.VariableDeclarations.NamedVariable)param.getVariables().get(0)).getName();
                if (VariableReferences.findRhsReferences((J)md.getBody(), (J.Identifier)variableName).isEmpty()) {
                    md = md.withParameters(Collections.emptyList());
                }
                return md.withReturnTypeExpression((TypeTree)md.getReturnTypeExpression().withPrefix(((J.Modifier)md.getModifiers().get(0)).getPrefix())).withModifiers(Collections.emptyList());
            }
        });
    }
}

