/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.util.List;
import lombok.AccessLevel;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

class LombokUtils {
    private static final AnnotationMatcher OVERRIDE_MATCHER = new AnnotationMatcher("java.lang.Override");

    LombokUtils() {
    }

    static boolean isGetter(Cursor cursor, AnnotationService service) {
        J.FieldAccess fieldAccess;
        Expression target;
        if (!(cursor.getValue() instanceof J.MethodDeclaration)) {
            return false;
        }
        J.MethodDeclaration method = (J.MethodDeclaration)cursor.getValue();
        if (method.getMethodType() == null) {
            return false;
        }
        if (!(method.getParameters().get(0) instanceof J.Empty) || method.getReturnTypeExpression() == null) {
            return false;
        }
        if (method.getBody() == null || method.getBody().getStatements().size() != 1 || !(method.getBody().getStatements().get(0) instanceof J.Return)) {
            return false;
        }
        if (LombokUtils.hasAnyAnnotatioOtherThanOverride(cursor, service)) {
            return false;
        }
        JavaType.FullyQualified declaringType = method.getMethodType().getDeclaringType();
        Expression returnExpression = ((J.Return)method.getBody().getStatements().get(0)).getExpression();
        if (returnExpression instanceof J.Identifier) {
            J.Identifier identifier = (J.Identifier)returnExpression;
            if (identifier.getFieldType() != null && declaringType == identifier.getFieldType().getOwner()) {
                if (identifier.getFieldType().hasFlags(new Flag[]{Flag.Static})) {
                    return false;
                }
                return LombokUtils.hasMatchingTypeAndGetterName(method, identifier.getType(), identifier.getSimpleName());
            }
        } else if (returnExpression instanceof J.FieldAccess && (target = (fieldAccess = (J.FieldAccess)returnExpression).getTarget()) instanceof J.Identifier && ((J.Identifier)target).getFieldType() != null && declaringType == ((J.Identifier)target).getFieldType().getOwner()) {
            if (fieldAccess.getName().getFieldType() != null && fieldAccess.getName().getFieldType().hasFlags(new Flag[]{Flag.Static})) {
                return false;
            }
            return LombokUtils.hasMatchingTypeAndGetterName(method, fieldAccess.getType(), fieldAccess.getSimpleName());
        }
        return false;
    }

    private static boolean hasMatchingTypeAndGetterName(J.MethodDeclaration method, @Nullable JavaType type, String simpleName) {
        if (method.getType() == type) {
            String deriveGetterMethodName = LombokUtils.deriveGetterMethodName(type, simpleName);
            return method.getSimpleName().equals(deriveGetterMethodName);
        }
        return false;
    }

    public static boolean isEffectivelyGetter(J.MethodDeclaration method) {
        if (!method.getParameters().isEmpty() && !(method.getParameters().get(0) instanceof J.Empty)) {
            return false;
        }
        if (method.getBody() == null || method.getBody().getStatements().size() != 1 || !(method.getBody().getStatements().get(0) instanceof J.Return)) {
            return false;
        }
        Expression returnExpression = ((J.Return)method.getBody().getStatements().get(0)).getExpression();
        if (!(returnExpression instanceof J.Identifier) && !(returnExpression instanceof J.FieldAccess)) {
            return false;
        }
        return method.getType() == returnExpression.getType();
    }

    public static String deriveGetterMethodName(@Nullable JavaType type, String fieldName) {
        if (type == JavaType.Primitive.Boolean) {
            boolean alreadyStartsWithIs;
            boolean bl = alreadyStartsWithIs = fieldName.length() >= 3 && fieldName.substring(0, 3).matches("is[A-Z]");
            if (alreadyStartsWithIs) {
                return fieldName;
            }
            return "is" + StringUtils.capitalize((String)fieldName);
        }
        return "get" + StringUtils.capitalize((String)fieldName);
    }

    static boolean isSetter(Cursor cursor, AnnotationService service) {
        Expression target;
        J.FieldAccess assignedField;
        if (!(cursor.getValue() instanceof J.MethodDeclaration)) {
            return false;
        }
        J.MethodDeclaration method = (J.MethodDeclaration)cursor.getValue();
        if (method.getType() != JavaType.Primitive.Void) {
            return false;
        }
        if (method.getParameters().size() != 1 || method.getParameters().get(0) instanceof J.Empty) {
            return false;
        }
        if (method.getBody() == null || method.getBody().getStatements().size() != 1 || !(method.getBody().getStatements().get(0) instanceof J.Assignment)) {
            return false;
        }
        if (LombokUtils.hasAnyAnnotatioOtherThanOverride(cursor, service)) {
            return false;
        }
        J.VariableDeclarations.NamedVariable param = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)method.getParameters().get(0)).getVariables().get(0);
        Expression variable = ((J.Assignment)method.getBody().getStatements().get(0)).getVariable();
        if (param.getType() != variable.getType()) {
            return false;
        }
        JavaType.FullyQualified declaringType = method.getMethodType().getDeclaringType();
        if (variable instanceof J.Identifier) {
            J.Identifier assignedVar = (J.Identifier)variable;
            if (LombokUtils.hasMatchingSetterMethodName(method, assignedVar.getSimpleName()) && assignedVar.getFieldType() != null && declaringType == assignedVar.getFieldType().getOwner()) {
                return !assignedVar.getFieldType().hasFlags(new Flag[]{Flag.Static});
            }
        } else if (variable instanceof J.FieldAccess && LombokUtils.hasMatchingSetterMethodName(method, (assignedField = (J.FieldAccess)variable).getSimpleName()) && (target = assignedField.getTarget()) instanceof J.Identifier && ((J.Identifier)target).getFieldType() != null && declaringType == ((J.Identifier)target).getFieldType().getOwner()) {
            return assignedField.getName().getFieldType() != null && !assignedField.getName().getFieldType().hasFlags(new Flag[]{Flag.Static});
        }
        return false;
    }

    private static boolean hasMatchingSetterMethodName(J.MethodDeclaration method, String simpleName) {
        return method.getSimpleName().equals("set" + StringUtils.capitalize((String)simpleName));
    }

    public static boolean isEffectivelySetter(J.MethodDeclaration method) {
        if (method.getType() != JavaType.Primitive.Void) {
            return false;
        }
        if (method.getParameters().size() != 1 || method.getParameters().get(0) instanceof J.Empty) {
            return false;
        }
        J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)method.getParameters().get(0);
        J.VariableDeclarations.NamedVariable param = (J.VariableDeclarations.NamedVariable)variableDeclarations.getVariables().get(0);
        String paramName = param.getName().toString();
        if (method.getBody() == null || method.getBody().getStatements().size() != 1 || !(method.getBody().getStatements().get(0) instanceof J.Assignment)) {
            return false;
        }
        J.Assignment assignment = (J.Assignment)method.getBody().getStatements().get(0);
        if (!(assignment.getVariable() instanceof J.FieldAccess) && !(assignment.getVariable() instanceof J.Identifier)) {
            return false;
        }
        JavaType fieldType = assignment.getVariable().getType();
        return assignment.getAssignment().toString().equals(paramName) && param.getType() != null && param.getType().equals((Object)fieldType);
    }

    public static String deriveSetterMethodName(JavaType.Variable fieldType) {
        return "set" + StringUtils.capitalize((String)fieldType.getName());
    }

    static AccessLevel getAccessLevel(J.MethodDeclaration methodDeclaration) {
        if (methodDeclaration.hasModifier(J.Modifier.Type.Public)) {
            return AccessLevel.PUBLIC;
        }
        if (methodDeclaration.hasModifier(J.Modifier.Type.Protected)) {
            return AccessLevel.PROTECTED;
        }
        if (methodDeclaration.hasModifier(J.Modifier.Type.Private)) {
            return AccessLevel.PRIVATE;
        }
        return AccessLevel.PACKAGE;
    }

    private static boolean hasAnyAnnotatioOtherThanOverride(Cursor cursor, AnnotationService service) {
        List annotations = service.getAllAnnotations(cursor);
        return !annotations.isEmpty() && (annotations.size() != 1 || !OVERRIDE_MATCHER.matches((J.Annotation)annotations.get(0)));
    }
}

