/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

public final class UseVarForPrimitive
extends Recipe {
    public String getDisplayName() {
        return "Use `var` for primitive-typed variables";
    }

    public String getDescription() {
        return "Try to apply local variable type inference `var` to primitive variables where possible. This recipe will not touch variable declarations with initializers containing ternary operators.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new VarForPrimitivesVisitor());
    }

    @Generated
    public UseVarForPrimitive() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseVarForPrimitive()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseVarForPrimitive)) {
            return false;
        }
        UseVarForPrimitive other = (UseVarForPrimitive)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseVarForPrimitive;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    static final class VarForPrimitivesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final JavaType.Primitive SHORT_TYPE = JavaType.Primitive.Short;
        private final JavaType.Primitive BYTE_TYPE = JavaType.Primitive.Byte;
        private final JavaTemplate template = JavaTemplate.builder((String)"var #{} = #{any()}").javaParser(JavaParser.fromJavaVersion()).build();

        VarForPrimitivesVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isNoPrimitive = !DeclarationCheck.isPrimitive(vd);
            boolean isByteVariable = DeclarationCheck.declarationHasType(vd, (JavaType)this.BYTE_TYPE);
            boolean isShortVariable = DeclarationCheck.declarationHasType(vd, (JavaType)this.SHORT_TYPE);
            if (isNoPrimitive || isByteVariable || isShortVariable) {
                return vd;
            }
            return this.transformToVar(vd);
        }

        private J.VariableDeclarations transformToVar(J.VariableDeclarations vd) {
            Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
            String simpleName = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getSimpleName();
            if (initializer instanceof J.Literal) {
                initializer = this.expandWithPrimitivTypeHint(vd, initializer);
            }
            if (vd.getModifiers().isEmpty()) {
                return (J.VariableDeclarations)this.template.apply(this.getCursor(), vd.getCoordinates().replace(), new Object[]{simpleName, initializer}).withPrefix(vd.getPrefix());
            }
            J.VariableDeclarations result = ((J.VariableDeclarations)this.template.apply(this.getCursor(), vd.getCoordinates().replace(), new Object[]{simpleName, initializer})).withModifiers(vd.getModifiers()).withPrefix(vd.getPrefix());
            return result.withTypeExpression((TypeTree)result.getTypeExpression().withPrefix(vd.getTypeExpression().getPrefix()));
        }

        private Expression expandWithPrimitivTypeHint(J.VariableDeclarations vd, Expression initializer) {
            String valueSource = ((J.Literal)initializer).getValueSource();
            if (valueSource == null) {
                return initializer;
            }
            boolean isLongLiteral = JavaType.Primitive.Long == vd.getType();
            boolean inferredAsLong = valueSource.endsWith("l") || valueSource.endsWith("L");
            boolean isFloatLiteral = JavaType.Primitive.Float == vd.getType();
            boolean inferredAsFloat = valueSource.endsWith("f") || valueSource.endsWith("F");
            boolean isDoubleLiteral = JavaType.Primitive.Double == vd.getType();
            boolean inferredAsDouble = valueSource.endsWith("d") || valueSource.endsWith("D") || valueSource.contains(".");
            String typNotation = null;
            if (isLongLiteral && !inferredAsLong) {
                typNotation = "L";
            } else if (isFloatLiteral && !inferredAsFloat) {
                typNotation = "F";
            } else if (isDoubleLiteral && !inferredAsDouble) {
                typNotation = "D";
            }
            if (typNotation != null) {
                initializer = ((J.Literal)initializer).withValueSource(String.format("%s%s", valueSource, typNotation));
            }
            return initializer;
        }
    }
}

