/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddPlugin;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="0.2.0")
public class AddSuppressionForIllegalReflectionWarningsPlugin
extends Recipe {
    private static final XPathMatcher PACKAGING_MATCHER = new XPathMatcher("/project/packaging");
    @Option(displayName="Version", description="An exact version number, or node-style semver selector used to select the version number.", required=false, example="29.X")
    private final String version;

    public String getDisplayName() {
        return "Add maven jar plugin to suppress illegal reflection warnings";
    }

    public String getDescription() {
        return "Adds a maven jar plugin that's configured to suppress Illegal Reflection Warnings.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, (Object)ctx);
                if (PACKAGING_MATCHER.matches(this.getCursor()) && t.getValue().isPresent() && ("ear".equals(t.getValue().get()) || "war".equals(t.getValue().get()))) {
                    String groupId = "org.apache.maven.plugins";
                    String artifactId = "maven-jar-plugin";
                    String version = StringUtils.isNullOrEmpty((String)AddSuppressionForIllegalReflectionWarningsPlugin.this.getVersion()) ? "3.2.0" : AddSuppressionForIllegalReflectionWarningsPlugin.this.getVersion();
                    String configuration = "<configuration>\n    <archive>\n        <manifestEntries>\n            <Add-Opens>java.base/java.lang java.base/java.util java.base/java.lang.reflect java.base/java.text java.desktop/java.awt.font</Add-Opens>\n        </manifestEntries>\n    </archive>\n</configuration>";
                    this.doAfterVisit(new AddPlugin(groupId, artifactId, version, configuration, null, null, null).getVisitor());
                }
                return t;
            }
        };
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @ConstructorProperties(value={"version"})
    @Generated
    public AddSuppressionForIllegalReflectionWarningsPlugin(String version) {
        this.version = version;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddSuppressionForIllegalReflectionWarningsPlugin)) {
            return false;
        }
        AddSuppressionForIllegalReflectionWarningsPlugin other = (AddSuppressionForIllegalReflectionWarningsPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddSuppressionForIllegalReflectionWarningsPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

