/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.util.Comparator;
import lombok.AccessLevel;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.migrate.lombok.LombokUtils;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class UseNoArgsConstructor
extends Recipe {
    public String getDisplayName() {
        return "Use `@NoArgsConstructor` where applicable";
    }

    public String getDescription() {
        return "Prefer the Lombok `@NoArgsConstructor` annotation over explicitly written out constructors.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (method.isConstructor() && method.getParameters().get(0) instanceof J.Empty && method.getBody() != null && method.getBody().getStatements().isEmpty()) {
                    final J.ClassDeclaration enclosing = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                    final AccessLevel accessLevel = LombokUtils.getAccessLevel(method);
                    this.doAfterVisit((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                            if (TypeUtils.isOfType((JavaType)classDecl.getType(), (JavaType)enclosing.getType())) {
                                String template = "@NoArgsConstructor" + (accessLevel == AccessLevel.PUBLIC ? "" : "(access = AccessLevel." + accessLevel.name() + ")");
                                this.maybeAddImport("lombok.AccessLevel");
                                this.maybeAddImport("lombok.NoArgsConstructor");
                                return (J.ClassDeclaration)JavaTemplate.builder((String)template).imports(new String[]{"lombok.*"}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"lombok"})).build().apply(this.getCursor(), classDecl.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                            }
                            return super.visitClassDeclaration(classDecl, (Object)ctx);
                        }
                    });
                    return null;
                }
                return super.visitMethodDeclaration(method, (Object)ctx);
            }
        };
    }

    @Generated
    public UseNoArgsConstructor() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseNoArgsConstructor()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseNoArgsConstructor)) {
            return false;
        }
        UseNoArgsConstructor other = (UseNoArgsConstructor)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UseNoArgsConstructor;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

