/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.local.LocalEventLoopGroup;
import io.netty.channel.local.LocalIoHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Replace all `EventLoopGroup`s with `MultiThreadIoEventLoopGroup`", description="Replaces Netty's `new *EventLoopGroup` with `new MultiThreadIoEventLoopGroup(*IoHandler.newFactory())`.", tags={"netty"})
public class EventLoopGroupToMultiThreadIoEventLoopGroup {

    @RecipeDescriptor(name="Replace `NioEventLoopGroup` with `MultiThreadIoEventLoopGroup`", description="Replace `new NioEventLoopGroup()` with `new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory())`.", tags={"netty", "nio"})
    public static class NioEventLoopGroupFactory {
        EventLoopGroup before() {
            return new NioEventLoopGroup();
        }

        EventLoopGroup after() {
            return new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        }
    }

    @RecipeDescriptor(name="Replace `LocalEventLoopGroup` with `MultiThreadIoEventLoopGroup`", description="Replace `new LocalEventLoopGroup()` with `new MultiThreadIoEventLoopGroup(LocalIoHandler.newFactory())`.", tags={"netty", "local"})
    public static class LocalEventLoopGroupFactory {
        EventLoopGroup before() {
            return new LocalEventLoopGroup();
        }

        EventLoopGroup after() {
            return new MultiThreadIoEventLoopGroup(LocalIoHandler.newFactory());
        }
    }

    @RecipeDescriptor(name="Replace `EpollEventLoopGroup` with `MultiThreadIoEventLoopGroup`", description="Replace `new EpollEventLoopGroup()` with `new MultiThreadIoEventLoopGroup(EpollIoHandler.newFactory())`.", tags={"netty", "epoll"})
    public static class EpollEventLoopGroupFactory {
        EventLoopGroup before() {
            return new EpollEventLoopGroup();
        }

        EventLoopGroup after() {
            return new MultiThreadIoEventLoopGroup(EpollIoHandler.newFactory());
        }
    }
}

