/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.netty;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class EventLoopGroupToMultiThreadIoEventLoopGroupRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace all `EventLoopGroup`s with `MultiThreadIoEventLoopGroup`";
    }

    public String getDescription() {
        return "Replaces Netty's `new *EventLoopGroup` with `new MultiThreadIoEventLoopGroup(*IoHandler.newFactory())`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("netty");
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new EpollEventLoopGroupFactoryRecipe(), new LocalEventLoopGroupFactoryRecipe(), new NioEventLoopGroupFactoryRecipe()});
    }

    @NullMarked
    public static class EpollEventLoopGroupFactoryRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `EpollEventLoopGroup` with `MultiThreadIoEventLoopGroup`";
        }

        public String getDescription() {
            return "Replace `new EpollEventLoopGroup()` with `new MultiThreadIoEventLoopGroup(EpollIoHandler.newFactory())`.";
        }

        public Set<String> getTags() {
            return new HashSet<String>(Arrays.asList("netty", "epoll"));
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new io.netty.channel.epoll.EpollEventLoopGroup()").bindType("io.netty.channel.EventLoopGroup").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"netty-transport-classes-epoll-4", "netty-transport-4", "netty-common-4"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("io.netty.channel.epoll.EpollEventLoopGroup");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new io.netty.channel.MultiThreadIoEventLoopGroup(io.netty.channel.epoll.EpollIoHandler.newFactory())").bindType("io.netty.channel.EventLoopGroup").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"netty-transport-4", "netty-common-4", "netty-transport-classes-epoll-4"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.netty.channel.EventLoopGroup", Boolean.valueOf(true)), new UsesType("io.netty.channel.epoll.EpollEventLoopGroup", Boolean.valueOf(true)), new UsesMethod("io.netty.channel.epoll.EpollEventLoopGroup <init>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LocalEventLoopGroupFactoryRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `LocalEventLoopGroup` with `MultiThreadIoEventLoopGroup`";
        }

        public String getDescription() {
            return "Replace `new LocalEventLoopGroup()` with `new MultiThreadIoEventLoopGroup(LocalIoHandler.newFactory())`.";
        }

        public Set<String> getTags() {
            return new HashSet<String>(Arrays.asList("netty", "local"));
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new io.netty.channel.local.LocalEventLoopGroup()").bindType("io.netty.channel.EventLoopGroup").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"netty-transport-4", "netty-common-4"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("io.netty.channel.local.LocalEventLoopGroup");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new io.netty.channel.MultiThreadIoEventLoopGroup(io.netty.channel.local.LocalIoHandler.newFactory())").bindType("io.netty.channel.EventLoopGroup").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"netty-transport-4", "netty-common-4"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.netty.channel.EventLoopGroup", Boolean.valueOf(true)), new UsesType("io.netty.channel.local.LocalEventLoopGroup", Boolean.valueOf(true)), new UsesMethod("io.netty.channel.local.LocalEventLoopGroup <init>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NioEventLoopGroupFactoryRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `NioEventLoopGroup` with `MultiThreadIoEventLoopGroup`";
        }

        public String getDescription() {
            return "Replace `new NioEventLoopGroup()` with `new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory())`.";
        }

        public Set<String> getTags() {
            return new HashSet<String>(Arrays.asList("netty", "nio"));
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new io.netty.channel.nio.NioEventLoopGroup()").bindType("io.netty.channel.EventLoopGroup").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"netty-transport-4", "netty-common-4"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("io.netty.channel.nio.NioEventLoopGroup");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new io.netty.channel.MultiThreadIoEventLoopGroup(io.netty.channel.nio.NioIoHandler.newFactory())").bindType("io.netty.channel.EventLoopGroup").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"netty-transport-4", "netty-common-4"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.netty.channel.EventLoopGroup", Boolean.valueOf(true)), new UsesType("io.netty.channel.nio.NioEventLoopGroup", Boolean.valueOf(true)), new UsesMethod("io.netty.channel.nio.NioEventLoopGroup <init>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

