/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.nodejs.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class NodeProjects
extends DataTable<Row> {
    public NodeProjects(Recipe recipe) {
        super(recipe, "Node.js projects", "Summary information about Node.js projects.");
    }

    public static final class Row {
        @Column(displayName="Name", description="The name of the package.")
        private final String name;
        @Column(displayName="Version", description="The version of the package.")
        private final String version;
        @Column(displayName="Has `package-lock.json`", description="Whether a lockfile is committed or not.")
        private final boolean hasPackageLock;

        public Row(String name, String version, boolean hasPackageLock) {
            this.name = name;
            this.version = version;
            this.hasPackageLock = hasPackageLock;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isHasPackageLock() {
            return this.hasPackageLock;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.isHasPackageLock() != other.isHasPackageLock()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasPackageLock() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "NodeProjects.Row(name=" + this.getName() + ", version=" + this.getVersion() + ", hasPackageLock=" + this.isHasPackageLock() + ")";
        }
    }
}

