/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.nodejs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.tree.Json;
import org.openrewrite.nodejs.Dependency;
import org.openrewrite.nodejs.ResolvedDependency;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class NodeResolutionResult {
    private final Collection<Dependency> dependencies;
    private final Collection<Dependency> devDependencies;

    @Nullable
    public Dependency getDependency(String name) {
        for (Dependency d : this.dependencies) {
            if (!d.getName().equals(name)) continue;
            return d;
        }
        for (Dependency d : this.devDependencies) {
            if (!d.getName().equals(name)) continue;
            return d;
        }
        return null;
    }

    public static NodeResolutionResult fromPackageLockJson(Json.Document lockfileJson) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        ArrayList<Dependency> devDependencies = new ArrayList<Dependency>();
        try {
            Lockfile lock = (Lockfile)((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).readValue(lockfileJson.printAll(), Lockfile.class);
            HashMap byName = new HashMap();
            lock.getPackages().forEach((pkgName, pkg) -> {
                boolean isRoot = "".equals(pkgName);
                if (!isRoot) {
                    List<Dependency> transitive;
                    if (pkg.getDependencies() != null) {
                        transitive = new ArrayList(pkg.getDependencies().size());
                        pkg.getDependencies().forEach((name, version) -> {
                            Dependency d = new Dependency((String)name, (VersionComparator)Semver.validate((String)version, null).getValue(), null);
                            transitive.add(d);
                            byName.computeIfAbsent(name, n -> new ArrayList()).add(d);
                        });
                    } else {
                        transitive = Collections.emptyList();
                    }
                    String name2 = pkgName.replaceFirst("node_modules/", "");
                    ResolvedDependency resolved = new ResolvedDependency(name2, pkg.getVersion(), pkg.getLicense(), transitive);
                    ((Collection)byName.getOrDefault(name2, Collections.emptyList())).forEach(d -> d.unsafeSetResolved(resolved));
                }
                if (pkg.getDependencies() != null) {
                    pkg.getDependencies().forEach((name, version) -> {
                        Dependency dep = new Dependency((String)name, (VersionComparator)Semver.validate((String)version, null).getValue(), null);
                        if (isRoot) {
                            dependencies.add(dep);
                        }
                        byName.computeIfAbsent(name, n -> new ArrayList()).add(dep);
                    });
                }
                if (pkg.getDevDependencies() != null) {
                    pkg.getDevDependencies().forEach((name, version) -> {
                        Dependency dep = new Dependency((String)name, (VersionComparator)Semver.validate((String)version, null).getValue(), null);
                        if (isRoot) {
                            devDependencies.add(dep);
                        }
                        byName.computeIfAbsent(name, n -> new ArrayList()).add(dep);
                    });
                }
            });
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return new NodeResolutionResult(dependencies, devDependencies);
    }

    @Generated
    public NodeResolutionResult(Collection<Dependency> dependencies, Collection<Dependency> devDependencies) {
        this.dependencies = dependencies;
        this.devDependencies = devDependencies;
    }

    @Generated
    public Collection<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public Collection<Dependency> getDevDependencies() {
        return this.devDependencies;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeResolutionResult)) {
            return false;
        }
        NodeResolutionResult other = (NodeResolutionResult)o;
        Collection<Dependency> this$dependencies = this.getDependencies();
        Collection<Dependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        Collection<Dependency> this$devDependencies = this.getDevDependencies();
        Collection<Dependency> other$devDependencies = other.getDevDependencies();
        return !(this$devDependencies == null ? other$devDependencies != null : !((Object)this$devDependencies).equals(other$devDependencies));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<Dependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        Collection<Dependency> $devDependencies = this.getDevDependencies();
        result = result * 59 + ($devDependencies == null ? 43 : ((Object)$devDependencies).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NodeResolutionResult(dependencies=" + this.getDependencies() + ", devDependencies=" + this.getDevDependencies() + ")";
    }

    static final class Lockfile {
        private final Map<String, Package> packages;

        @Generated
        public Lockfile(Map<String, Package> packages) {
            this.packages = packages;
        }

        @Generated
        public Map<String, Package> getPackages() {
            return this.packages;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lockfile)) {
                return false;
            }
            Lockfile other = (Lockfile)o;
            Map<String, Package> this$packages = this.getPackages();
            Map<String, Package> other$packages = other.getPackages();
            return !(this$packages == null ? other$packages != null : !((Object)this$packages).equals(other$packages));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Package> $packages = this.getPackages();
            result = result * 59 + ($packages == null ? 43 : ((Object)$packages).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NodeResolutionResult.Lockfile(packages=" + this.getPackages() + ")";
        }

        static final class Package {
            private final String version;
            private final String license;
            private final Map<String, String> dependencies;
            private final Map<String, String> devDependencies;

            @Generated
            public Package(String version, String license, Map<String, String> dependencies, Map<String, String> devDependencies) {
                this.version = version;
                this.license = license;
                this.dependencies = dependencies;
                this.devDependencies = devDependencies;
            }

            @Generated
            public String getVersion() {
                return this.version;
            }

            @Generated
            public String getLicense() {
                return this.license;
            }

            @Generated
            public Map<String, String> getDependencies() {
                return this.dependencies;
            }

            @Generated
            public Map<String, String> getDevDependencies() {
                return this.devDependencies;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Package)) {
                    return false;
                }
                Package other = (Package)o;
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                    return false;
                }
                String this$license = this.getLicense();
                String other$license = other.getLicense();
                if (this$license == null ? other$license != null : !this$license.equals(other$license)) {
                    return false;
                }
                Map<String, String> this$dependencies = this.getDependencies();
                Map<String, String> other$dependencies = other.getDependencies();
                if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
                    return false;
                }
                Map<String, String> this$devDependencies = this.getDevDependencies();
                Map<String, String> other$devDependencies = other.getDevDependencies();
                return !(this$devDependencies == null ? other$devDependencies != null : !((Object)this$devDependencies).equals(other$devDependencies));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                String $license = this.getLicense();
                result = result * 59 + ($license == null ? 43 : $license.hashCode());
                Map<String, String> $dependencies = this.getDependencies();
                result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
                Map<String, String> $devDependencies = this.getDevDependencies();
                result = result * 59 + ($devDependencies == null ? 43 : ((Object)$devDependencies).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "NodeResolutionResult.Lockfile.Package(version=" + this.getVersion() + ", license=" + this.getLicense() + ", dependencies=" + this.getDependencies() + ", devDependencies=" + this.getDevDependencies() + ")";
            }
        }
    }
}

