/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.openapi.swagger;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeAnnotationAttributeName;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotationAttribute;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.openapi.swagger.AnnotationUtils;

public class MigrateApiToTag
extends Recipe {
    private static final String FQN_API = "io.swagger.annotations.Api";
    private static final String FQN_TAG = "io.swagger.v3.oas.annotations.tags.Tag";
    private static final String FQN_TAGS = "io.swagger.v3.oas.annotations.tags.Tags";
    private static final String FQN_HIDDEN = "io.swagger.v3.oas.annotations.Hidden";
    @Language(value="java")
    private static final String HIDDEN_CLASS = "package io.swagger.v3.oas.annotations;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.ANNOTATION_TYPE;\nimport static java.lang.annotation.ElementType.TYPE;\nimport static java.lang.annotation.ElementType.FIELD;\nimport static java.lang.annotation.ElementType.METHOD;\n@Target({METHOD, TYPE, FIELD, ANNOTATION_TYPE})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface Hidden {}";
    @Language(value="java")
    private static final String TAGS_CLASS = "package io.swagger.v3.oas.annotations.tags;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.METHOD, ElementType.TYPE, ElementType.ANNOTATION_TYPE})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface Tags {\n    Tag[] value() default {};\n}";
    @Language(value="java")
    private static final String TAG_CLASS = "package io.swagger.v3.oas.annotations.tags;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.METHOD, ElementType.TYPE, ElementType.ANNOTATION_TYPE})\n@Retention(RetentionPolicy.RUNTIME)\n@Repeatable(Tags.class)\npublic @interface Tag {\n    String name();\n    String description() default \"\";\n}";

    public String getDisplayName() {
        return "Migrate from `@Api` to `@Tag`";
    }

    public String getDescription() {
        return "Converts `@Api` to `@Tag` annotation and converts the directly mappable attributes and removes the others.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(FQN_API, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final AnnotationMatcher apiMatcher = new AnnotationMatcher("io.swagger.annotations.Api");

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation ann = super.visitAnnotation(annotation, (Object)ctx);
                if (this.apiMatcher.matches(ann)) {
                    this.doAfterVisit(new ChangeAnnotationAttributeName(MigrateApiToTag.FQN_API, "value", "name").getVisitor());
                    this.doAfterVisit(new RemoveAnnotationAttribute(MigrateApiToTag.FQN_API, "hidden").getVisitor());
                    this.doAfterVisit(new ChangeType(MigrateApiToTag.FQN_API, MigrateApiToTag.FQN_TAG, Boolean.valueOf(true)).getVisitor());
                    Map<String, Expression> annoAssignments = AnnotationUtils.extractArgumentAssignments(ann);
                    if (annoAssignments.containsKey("tags") || annoAssignments.containsKey("hidden")) {
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, MigrateApiToTag.FQN_API, annoAssignments);
                    }
                    if (annoAssignments.containsKey("tags")) {
                        return null;
                    }
                }
                return ann;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                boolean hidden;
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                Map annoArguments = (Map)this.getCursor().getMessage(MigrateApiToTag.FQN_API);
                if (annoArguments == null) {
                    return cd;
                }
                Expression hiddenAssignment = (Expression)annoArguments.get("hidden");
                if (hiddenAssignment != null && (hidden = Boolean.parseBoolean(hiddenAssignment.printTrimmed()))) {
                    this.maybeAddImport(MigrateApiToTag.FQN_HIDDEN, false);
                    cd = (J.ClassDeclaration)JavaTemplate.builder((String)"@Hidden").imports(new String[]{MigrateApiToTag.FQN_HIDDEN}).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{MigrateApiToTag.HIDDEN_CLASS})).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                }
                Expression descAssignment = (Expression)annoArguments.get("description");
                Expression tagsAssignment = (Expression)annoArguments.get("tags");
                if (tagsAssignment instanceof J.NewArray) {
                    J.NewArray newArray = (J.NewArray)tagsAssignment;
                    List initializer = Objects.requireNonNull(newArray.getInitializer());
                    cd = initializer.size() == 1 ? this.addTagAnnotation(cd, (Expression)initializer.get(0), descAssignment) : this.addTagsAnnotation(cd, initializer, descAssignment);
                } else if (tagsAssignment != null) {
                    cd = this.addTagAnnotation(cd, tagsAssignment, descAssignment);
                }
                return (J.ClassDeclaration)this.maybeAutoFormat((J)classDecl, (J)cd, (J)cd.getName(), ctx, this.getCursor().getParentTreeCursor());
            }

            private J.ClassDeclaration addTagsAnnotation(J.ClassDeclaration cd, List<Expression> tagsAssignments, @Nullable Expression descAssignment) {
                StringBuilder template = new StringBuilder("@Tags({");
                ArrayList<Expression> templateArgs = new ArrayList<Expression>();
                for (Expression expression : tagsAssignments) {
                    if (!templateArgs.isEmpty()) {
                        template.append(",");
                    }
                    template.append("\n@Tag(name = #{any()}");
                    templateArgs.add(expression);
                    if (descAssignment != null) {
                        template.append(", description = #{any()}");
                        templateArgs.add(descAssignment);
                    }
                    template.append(")");
                }
                template.append("\n})");
                this.maybeAddImport(MigrateApiToTag.FQN_TAG);
                this.maybeAddImport(MigrateApiToTag.FQN_TAGS);
                return (J.ClassDeclaration)JavaTemplate.builder((String)template.toString()).imports(new String[]{MigrateApiToTag.FQN_TAGS, MigrateApiToTag.FQN_TAG}).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{MigrateApiToTag.TAGS_CLASS, MigrateApiToTag.TAG_CLASS})).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), templateArgs.toArray());
            }

            private J.ClassDeclaration addTagAnnotation(J.ClassDeclaration cd, Expression tagsAssignment, @Nullable Expression descAssignment) {
                StringBuilder template = new StringBuilder("@Tag(name = #{any()}");
                ArrayList<Expression> templateArgs = new ArrayList<Expression>();
                templateArgs.add(tagsAssignment);
                if (descAssignment != null) {
                    template.append(", description = #{any()}");
                    templateArgs.add(descAssignment);
                }
                template.append(")");
                this.maybeAddImport(MigrateApiToTag.FQN_TAG);
                cd = (J.ClassDeclaration)JavaTemplate.builder((String)template.toString()).imports(new String[]{MigrateApiToTag.FQN_TAG}).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{MigrateApiToTag.TAGS_CLASS, MigrateApiToTag.TAG_CLASS})).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), templateArgs.toArray());
                return cd;
            }
        });
    }
}

