/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sandbox;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class GetToOrElseThrow
extends Recipe {
    public static final MethodMatcher OPTIONAL_GET = new MethodMatcher("java.util.Optional get()");

    public String getDisplayName() {
        return "Replace `Optional::get` with `Optional::orElseThrow`";
    }

    public String getDescription() {
        return "The latter explicitly handles the empty case.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(OPTIONAL_GET);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), (String)"#{any(java.util.Optional)}.orElseThrow(NoSuchElementException::new)").imports(new String[]{"java.util.NoSuchElementException"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (OPTIONAL_GET.matches(method)) {
                    this.maybeAddImport("java.util.NoSuchElementException");
                    return method.withTemplate((SourceTemplate)this.template, method.getCoordinates().replace(), new Object[]{method.getSelect()});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }
}

