/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sandbox;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.UnsafeJavaTypeVisitor;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.sandbox.JavaTypeVariants;

class JavaTypeDeduplicationTypeVisitor
extends UnsafeJavaTypeVisitor<Integer> {
    private final Map<JavaType, JavaType> provenEquivalencies = new IdentityHashMap<JavaType, JavaType>();
    private final Map<JavaType, JavaType> proposedEquivalencies = new IdentityHashMap<JavaType, JavaType>();
    private final JavaTypeVariants multiRepoCache;

    public JavaType visit(@Nullable JavaType javaType, Integer p) {
        if (javaType == null) {
            return null;
        }
        JavaType proven = this.provenEquivalencies.get(javaType);
        if (proven != null) {
            return proven;
        }
        JavaType proposed = this.proposedEquivalencies.get(javaType);
        if (proposed != null) {
            return proposed;
        }
        Set<JavaType> variants = this.multiRepoCache.variantsOf(javaType);
        for (JavaType variant : new ArrayList<JavaType>(variants)) {
            this.proposedEquivalencies.put(javaType, variant);
            boolean isSame = this.isEqual(javaType, variant);
            this.proposedEquivalencies.remove(javaType);
            if (!isSame) continue;
            this.provenEquivalencies.put(javaType, variant);
            return variant;
        }
        this.proposedEquivalencies.put(javaType, javaType);
        JavaType jt = super.visit(javaType, (Object)p);
        this.proposedEquivalencies.remove(javaType);
        variants.add(jt);
        this.provenEquivalencies.put(javaType, jt);
        return jt;
    }

    private boolean isEqual(JavaType jt, JavaType variant) {
        if (jt == variant) {
            return true;
        }
        if (!jt.getClass().isAssignableFrom(variant.getClass()) && !variant.getClass().isAssignableFrom(jt.getClass())) {
            return false;
        }
        if (jt instanceof JavaType.Class) {
            JavaType.Class c = (JavaType.Class)jt;
            JavaType.Class varc = (JavaType.Class)variant;
            return c.getFlagsBitMap() == varc.getFlagsBitMap() && c.getFullyQualifiedName().equals(varc.getFullyQualifiedName()) && c.getKind() == varc.getKind() && this.isSame((JavaType)c.getOwningClass(), (JavaType)varc.getOwningClass()) && this.isSame((JavaType)c.getSupertype(), (JavaType)varc.getSupertype()) && this.isSame(c.getInterfaces(), varc.getInterfaces()) && this.isSame(c.getMethods(), varc.getMethods()) && this.isSame(c.getMembers(), varc.getMembers()) && this.isSame(c.getAnnotations(), varc.getAnnotations()) && this.isSame(c.getTypeParameters(), varc.getTypeParameters());
        }
        if (jt instanceof JavaType.Parameterized) {
            JavaType.Parameterized p = (JavaType.Parameterized)jt;
            JavaType.Parameterized varp = (JavaType.Parameterized)variant;
            return this.isSame((JavaType)p.getType(), (JavaType)varp.getType()) && this.isSame(p.getTypeParameters(), varp.getTypeParameters());
        }
        if (jt instanceof JavaType.Array) {
            JavaType.Array a = (JavaType.Array)jt;
            JavaType.Array vara = (JavaType.Array)variant;
            return this.isSame(a.getElemType(), vara.getElemType());
        }
        if (jt instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable g = (JavaType.GenericTypeVariable)jt;
            JavaType.GenericTypeVariable varg = (JavaType.GenericTypeVariable)variant;
            return g.getName().equals(varg.getName()) && g.getVariance() == varg.getVariance() && this.isSame(g.getBounds(), varg.getBounds());
        }
        if (jt instanceof JavaType.Method) {
            JavaType.Method m = (JavaType.Method)jt;
            JavaType.Method varm = (JavaType.Method)variant;
            return m.getName().equals(varm.getName()) && m.getFlagsBitMap() == varm.getFlagsBitMap() && this.isSame(m.getAnnotations(), varm.getAnnotations()) && this.isSame(m.getParameterTypes(), varm.getParameterTypes()) && this.isSame(m.getReturnType(), varm.getReturnType()) && this.isSame(m.getThrownExceptions(), varm.getThrownExceptions()) && this.isSame((JavaType)m.getDeclaringType(), (JavaType)varm.getDeclaringType());
        }
        if (jt instanceof JavaType.Variable) {
            JavaType.Variable v = (JavaType.Variable)jt;
            JavaType.Variable varv = (JavaType.Variable)variant;
            return v.getName().equals(varv.getName()) && this.isSame(v.getOwner(), varv.getOwner());
        }
        if (jt instanceof JavaType.MultiCatch) {
            JavaType.MultiCatch m = (JavaType.MultiCatch)jt;
            JavaType.MultiCatch varm = (JavaType.MultiCatch)variant;
            return this.isSame(m.getThrowableTypes(), varm.getThrowableTypes());
        }
        return true;
    }

    private boolean isSame(@Nullable JavaType test, @Nullable JavaType variant) {
        return this.visit(test, 0) == variant;
    }

    private boolean isSame(@Nullable List<? extends JavaType> test, @Nullable List<? extends JavaType> variant) {
        if (test == null && variant == null) {
            return true;
        }
        if (test == null || variant == null || test.size() != variant.size()) {
            return false;
        }
        for (int i = 0; i < test.size(); ++i) {
            if (this.visit(test.get(i), 0) == variant.get(i)) continue;
            return false;
        }
        return true;
    }

    public JavaTypeDeduplicationTypeVisitor(JavaTypeVariants multiRepoCache) {
        this.multiRepoCache = multiRepoCache;
    }
}

