/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sandbox;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.sandbox.JavaTypeUtils;
import org.openrewrite.sandbox.SingleLoopUnsafeJavaTypeVisitor;
import org.openrewrite.sandbox.table.TypeReport;

public class JavaTypeDensityStudy
extends Recipe {
    transient TypeReport report = new TypeReport(this);

    public String getDisplayName() {
        return "Studying type variance";
    }

    public String getDescription() {
        return "Testing hypotheses around reducing type variance and weight.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        final Set privatePackageMethodsInSource = Collections.newSetFromMap(new IdentityHashMap());
        for (SourceFile sourceFile : before) {
            new JavaIsoVisitor<Integer>(){

                public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Integer integer) {
                    JavaType.Method t = method.getMethodType();
                    if (t != null && !t.hasFlags(new Flag[]{Flag.Public}) && !t.hasFlags(new Flag[]{Flag.Protected})) {
                        privatePackageMethodsInSource.add(t);
                    }
                    return super.visitMethodDeclaration(method, (Object)integer);
                }

                public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Integer integer) {
                    J.ClassDeclaration c = super.visitClassDeclaration(classDecl, (Object)integer);
                    for (Statement stat : c.getBody().getStatements()) {
                        if (!(stat instanceof J.VariableDeclarations)) continue;
                        for (J.VariableDeclarations.NamedVariable variable : ((J.VariableDeclarations)stat).getVariables()) {
                            JavaType.Variable t = variable.getVariableType();
                            if (t == null || t.hasFlags(new Flag[]{Flag.Public}) || t.hasFlags(new Flag[]{Flag.Protected})) continue;
                            privatePackageMethodsInSource.add(t);
                        }
                    }
                    return c;
                }
            }.visit((Tree)sourceFile, (Object)0);
        }
        for (SourceFile cu : before) {
            if (!(cu instanceof JavaSourceFile)) continue;
            SourceFile s = JavaTypeUtils.dedupTypes(cu);
            IdentityHashMap<JavaType, JavaType> typeClones = new IdentityHashMap<JavaType, JavaType>();
            SourceFile sCloned = JavaTypeUtils.cloneTypes(s, typeClones);
            final IdentityHashMap<JavaType, JavaType> invertedTypeClones = new IdentityHashMap<JavaType, JavaType>();
            for (Map.Entry<JavaType, JavaType> entry : typeClones.entrySet()) {
                invertedTypeClones.put(entry.getValue(), entry.getKey());
            }
            typeClones.clear();
            SourceFile noPrivateMethodsAndFields = (SourceFile)new JavaIsoVisitor<Integer>(){

                public JavaType visitType(@Nullable JavaType javaType, final Integer p) {
                    return new SingleLoopUnsafeJavaTypeVisitor(){

                        public JavaType visitClass(JavaType.Class aClass, Integer integer) {
                            return aClass.unsafeSet(ListUtils.map((List)aClass.getTypeParameters(), t -> this.visit((JavaType)t, p)), (JavaType.FullyQualified)this.visit((JavaType)aClass.getSupertype(), p), (JavaType.FullyQualified)this.visit((JavaType)aClass.getOwningClass(), p), ListUtils.map((List)aClass.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)), ListUtils.map((List)aClass.getInterfaces(), i -> (JavaType.FullyQualified)this.visit((JavaType)i, p)), ListUtils.map((List)aClass.getMembers(), m -> {
                                if (!(privatePackageMethodsInSource.contains(invertedTypeClones.get(m)) || m.hasFlags(new Flag[]{Flag.Public}) || m.hasFlags(new Flag[]{Flag.Protected}))) {
                                    return null;
                                }
                                return (JavaType.Variable)this.visit((JavaType)m, p);
                            }), ListUtils.map((List)aClass.getMethods(), m -> {
                                if (!(privatePackageMethodsInSource.contains(invertedTypeClones.get(m)) || m.hasFlags(new Flag[]{Flag.Public}) || m.hasFlags(new Flag[]{Flag.Protected}))) {
                                    return null;
                                }
                                return (JavaType.Method)this.visit((JavaType)m, p);
                            }));
                        }
                    }.visit(javaType, p);
                }
            }.visitNonNull((Tree)sCloned, (Object)0);
            this.report.insertRow(ctx, new TypeReport.Row(cu.getSourcePath().toString(), JavaTypeUtils.weigh(s), JavaTypeUtils.weigh(noPrivateMethodsAndFields)));
        }
        return before;
    }
}

