/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sandbox;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.UnsafeJavaTypeVisitor;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.sandbox.JavaTypeDeduplicationVisitor;
import org.openrewrite.sandbox.JavaTypeVariants;

class JavaTypeUtils {
    JavaTypeUtils() {
    }

    public static long weigh(SourceFile sourceFile) {
        HashSet ids = new HashSet();
        return sourceFile.getWeight(id -> ids.add(System.identityHashCode(id)));
    }

    public static SourceFile cloneTypes(SourceFile sourceFile) {
        return JavaTypeUtils.cloneTypes(sourceFile, new IdentityHashMap<JavaType, JavaType>());
    }

    public static SourceFile cloneTypes(SourceFile sourceFile, IdentityHashMap<JavaType, JavaType> clones) {
        JavaTypeUtils.buildClones(sourceFile, clones);
        return JavaTypeUtils.replaceWithClones(sourceFile, clones);
    }

    public static SourceFile dedupTypes(SourceFile s) {
        return (SourceFile)new JavaTypeDeduplicationVisitor(new JavaTypeVariants()).visitNonNull((Tree)s, 0);
    }

    private static void buildClones(SourceFile sourceFile, final IdentityHashMap<JavaType, JavaType> cloned) {
        new JavaIsoVisitor<Integer>(){

            public JavaType visitType(@Nullable JavaType javaType, final Integer p) {
                return new JavaTypeVisitor<Integer>(){

                    public JavaType visit(@Nullable JavaType javaType, Integer integer) {
                        if (javaType == null) {
                            return null;
                        }
                        JavaType clone = (JavaType)cloned.get(javaType);
                        if (clone != null) {
                            return clone;
                        }
                        clone = javaType;
                        if (javaType instanceof JavaType.Array) {
                            JavaType.Array t = (JavaType.Array)javaType;
                            clone = new JavaType.Array(null, t.getElemType());
                        } else if (javaType instanceof JavaType.Class) {
                            JavaType.Class t = (JavaType.Class)javaType;
                            clone = new JavaType.Class(null, t.getFlagsBitMap(), t.getFullyQualifiedName(), t.getKind(), t.getTypeParameters(), t.getSupertype(), t.getOwningClass(), t.getAnnotations(), t.getInterfaces(), t.getMembers(), t.getMethods());
                        } else if (javaType instanceof JavaType.GenericTypeVariable) {
                            JavaType.GenericTypeVariable t = (JavaType.GenericTypeVariable)javaType;
                            clone = new JavaType.GenericTypeVariable(null, t.getName(), t.getVariance(), t.getBounds());
                        } else if (javaType instanceof JavaType.Method) {
                            JavaType.Method t = (JavaType.Method)javaType;
                            clone = new JavaType.Method(null, t.getFlagsBitMap(), t.getDeclaringType(), t.getName(), t.getReturnType(), t.getParameterNames(), t.getParameterTypes(), t.getThrownExceptions(), t.getAnnotations());
                        } else if (javaType instanceof JavaType.MultiCatch) {
                            JavaType.MultiCatch t = (JavaType.MultiCatch)javaType;
                            clone = new JavaType.MultiCatch(t.getThrowableTypes());
                        } else if (javaType instanceof JavaType.Parameterized) {
                            JavaType.Parameterized t = (JavaType.Parameterized)javaType;
                            clone = new JavaType.Parameterized(null, t.getType(), t.getTypeParameters());
                        } else if (javaType instanceof JavaType.Variable) {
                            JavaType.Variable t = (JavaType.Variable)javaType;
                            clone = new JavaType.Variable(null, t.getFlagsBitMap(), t.getName(), t.getOwner(), t.getType(), t.getAnnotations());
                        }
                        cloned.put(javaType, clone);
                        return super.visit(javaType, (Object)p);
                    }
                }.visit(javaType, p);
            }
        }.visit((Tree)sourceFile, (Object)0);
    }

    static SourceFile replaceWithClones(SourceFile sourceFile, final Map<JavaType, JavaType> clones) {
        final Set seen = Collections.newSetFromMap(new IdentityHashMap());
        return (SourceFile)new JavaIsoVisitor<Integer>(){

            public JavaType visitType(@Nullable JavaType javaType, Integer p) {
                return new UnsafeJavaTypeVisitor<Integer>(){

                    public JavaType visit(@Nullable JavaType javaType, Integer p) {
                        JavaType replace = clones.getOrDefault(javaType, javaType);
                        if (seen.add(replace)) {
                            return super.visit(replace, (Object)p);
                        }
                        return replace;
                    }
                }.visit(javaType, p);
            }
        }.visitNonNull((Tree)sourceFile, (Object)0);
    }
}

