/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sandbox.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

@JsonIgnoreType
public class TypeReport
extends DataTable<Row> {
    public TypeReport(Recipe recipe) {
        super(recipe, Row.class, TypeReport.class.getName(), "Java type report", "Contains a report about Java type weight.");
    }

    public static final class Row {
        @Column(displayName="Source file", description="A sourc file path.")
        private final String sourceFile;
        @Column(displayName="Weight", description="Existing weight.")
        private final Long weight;
        @Column(displayName="Weight without private visibility", description="Weight without private method names and fields.")
        private final Long weightWithoutPrivateMethodNamesAndFields;

        public Row(String sourceFile, Long weight, Long weightWithoutPrivateMethodNamesAndFields) {
            this.sourceFile = sourceFile;
            this.weight = weight;
            this.weightWithoutPrivateMethodNamesAndFields = weightWithoutPrivateMethodNamesAndFields;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public Long getWeight() {
            return this.weight;
        }

        public Long getWeightWithoutPrivateMethodNamesAndFields() {
            return this.weightWithoutPrivateMethodNamesAndFields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Long this$weight = this.getWeight();
            Long other$weight = other.getWeight();
            if (this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight)) {
                return false;
            }
            Long this$weightWithoutPrivateMethodNamesAndFields = this.getWeightWithoutPrivateMethodNamesAndFields();
            Long other$weightWithoutPrivateMethodNamesAndFields = other.getWeightWithoutPrivateMethodNamesAndFields();
            if (this$weightWithoutPrivateMethodNamesAndFields == null ? other$weightWithoutPrivateMethodNamesAndFields != null : !((Object)this$weightWithoutPrivateMethodNamesAndFields).equals(other$weightWithoutPrivateMethodNamesAndFields)) {
                return false;
            }
            String this$sourceFile = this.getSourceFile();
            String other$sourceFile = other.getSourceFile();
            return !(this$sourceFile == null ? other$sourceFile != null : !this$sourceFile.equals(other$sourceFile));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $weight = this.getWeight();
            result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
            Long $weightWithoutPrivateMethodNamesAndFields = this.getWeightWithoutPrivateMethodNamesAndFields();
            result = result * 59 + ($weightWithoutPrivateMethodNamesAndFields == null ? 43 : ((Object)$weightWithoutPrivateMethodNamesAndFields).hashCode());
            String $sourceFile = this.getSourceFile();
            result = result * 59 + ($sourceFile == null ? 43 : $sourceFile.hashCode());
            return result;
        }

        public String toString() {
            return "TypeReport.Row(sourceFile=" + this.getSourceFile() + ", weight=" + this.getWeight() + ", weightWithoutPrivateMethodNamesAndFields=" + this.getWeightWithoutPrivateMethodNamesAndFields() + ")";
        }
    }
}

