/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.quarkus.quarkus2;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class GrpcServiceAnnotationToGrpcClient
extends Recipe {
    private static final String GRPC_SERVICE_ANNOTATION_FQN = "io.quarkus.grpc.runtime.annotations.GrpcService";
    private static final String GRPC_CLIENT_ANNOTATION_FQN = "io.quarkus.grpc.GrpcClient";

    public String getDisplayName() {
        return "Use `@GrpcClient`";
    }

    public String getDescription() {
        return "The `@GrpcService` annotation is replaced with `@GrpcClient` in Quarkus 2.x. Removes the optional `@GrpcClient.value()` unless the service name is different from the name of annotated element.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType(GRPC_SERVICE_ANNOTATION_FQN);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GrpcServiceToGrpcClientAnnotationVisitor();
    }

    private static class GrpcServiceToGrpcClientAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private GrpcServiceToGrpcClientAnnotationVisitor() {
        }

        private static boolean shouldRemoveArgument(J.VariableDeclarations.NamedVariable namedVariable, J.Literal assignValue) {
            Object value = assignValue.getValue();
            assert (value != null);
            return namedVariable.getSimpleName().equals(value);
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.doAfterVisit((Recipe)new ChangeType(GrpcServiceAnnotationToGrpcClient.GRPC_SERVICE_ANNOTATION_FQN, GrpcServiceAnnotationToGrpcClient.GRPC_CLIENT_ANNOTATION_FQN));
            return super.visitCompilationUnit(cu, (Object)ctx);
        }

        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
            if (TypeUtils.isOfClassType((JavaType)annotation.getType(), (String)GrpcServiceAnnotationToGrpcClient.GRPC_SERVICE_ANNOTATION_FQN) && a.getArguments() != null && this.getCursor().getParentOrThrow().getValue() instanceof J.VariableDeclarations) {
                a = a.withArguments(ListUtils.map((List)a.getArguments(), arg -> {
                    J.Identifier assignName;
                    J.Assignment assignment;
                    Cursor varDecsCursor = this.getCursor().getParentOrThrow();
                    J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)varDecsCursor.getValue()).getVariables().get(0);
                    if (arg instanceof J.Assignment ? (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && assignment.getAssignment() instanceof J.Literal && "value".equals((assignName = (J.Identifier)assignment.getVariable()).getSimpleName()) && GrpcServiceToGrpcClientAnnotationVisitor.shouldRemoveArgument(namedVariable, (J.Literal)assignment.getAssignment()) : arg instanceof J.Literal && GrpcServiceToGrpcClientAnnotationVisitor.shouldRemoveArgument(namedVariable, (J.Literal)arg)) {
                        return null;
                    }
                    return arg;
                }));
            }
            return a;
        }
    }
}

