/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.quarkus;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class MultiTransformHotStreamToMultiHotStream
extends Recipe {
    private static final MethodMatcher hotStreamMethodMatcher = new MethodMatcher("io.smallrye.mutiny.groups.MultiTransform toHotStream()");

    public String getDisplayName() {
        return "Use Mutiny `multi.toHotStream()`.";
    }

    public String getDescription() {
        return "Replace Mutiny API usages of `multi.transform().toHotStream()` with `multi.toHotStream()`.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(hotStreamMethodMatcher);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final MethodMatcher transformMethodMatcher = new MethodMatcher("io.smallrye.mutiny.Multi transform()");
            final MethodMatcher selectMethodMatcher = new MethodMatcher("io.smallrye.mutiny.Multi select()");

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation mSelect;
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)executionContext);
                if (hotStreamMethodMatcher.matches(mi) && mi.getSelect() != null && mi.getSelect() instanceof J.MethodInvocation && (this.transformMethodMatcher.matches(mSelect = (J.MethodInvocation)mi.getSelect()) || this.selectMethodMatcher.matches(mSelect))) {
                    return mi.withSelect(mSelect.getSelect());
                }
                return mi;
            }
        };
    }
}

