/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.quarkus.quarkus2;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class UseIdentifierOnDefaultKafkaBroker
extends Recipe {
    private static final ThreadLocal<JavaParser> JAVA_PARSER = ThreadLocal.withInitial(() -> JavaParser.fromJavaVersion().dependsOn(Collections.singletonList(Parser.Input.fromString((String)"package io.smallrye.common.annotation;\npublic interface Identifier {\n    String value();\n}"))).build());

    public String getDisplayName() {
        return "Use `@Identifier(\"default-kafka-broker\")`";
    }

    public String getDescription() {
        return "Use `@io.smallrye.common.annotation.Identifier` on default kafka broker configuration.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("javax.inject.Named");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UseIdentifierOnDefaultKafkaBrokerVisitor();
    }

    private static class UseIdentifierOnDefaultKafkaBrokerVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final AnnotationMatcher MATCHER = new AnnotationMatcher("@javax.inject.Named(\"default-kafka-broker\")");

        private UseIdentifierOnDefaultKafkaBrokerVisitor() {
        }

        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
            if (MATCHER.matches(a)) {
                this.maybeAddImport("io.smallrye.common.annotation.Identifier");
                this.maybeRemoveImport("javax.inject.Named");
                a = (J.Annotation)a.withTemplate(JavaTemplate.builder(() -> ((UseIdentifierOnDefaultKafkaBrokerVisitor)this).getCursor(), (String)"@Identifier(\"default-kafka-broker\")").javaParser(JAVA_PARSER::get).imports(new String[]{"io.smallrye.common.annotation.Identifier"}).build(), a.getCoordinates().replace(), new Object[0]);
            }
            return a;
        }
    }
}

