/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.quarkus.quarkus2;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class UseReactivePanacheMongoEntityBaseUniT
extends Recipe {
    private static final MethodMatcher PERSIST_MATCHER = new MethodMatcher("io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoEntityBase persist()");
    private static final MethodMatcher UPDATE_MATCHER = new MethodMatcher("io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoEntityBase update()");
    private static final MethodMatcher PERSIST_OR_UPDATE_MATCHER = new MethodMatcher("io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoEntityBase persistOrUpdate()");
    private static final ThreadLocal<JavaParser> PARSER = ThreadLocal.withInitial(() -> JavaParser.fromJavaVersion().dependsOn((Collection)Stream.of(Parser.Input.fromString((String)"package io.smallrye.mutiny;public interface Uni<T> {    Uni<Void> replaceWithVoid() {};}"), Parser.Input.fromString((String)"package io.quarkus.mongodb.panache.reactive;import io.smallrye.mutiny.Uni;public abstract class ReactivePanacheMongoEntityBase {    public <T extends ReactivePanacheMongoEntityBase> Uni<T> persist() {};    public <T extends ReactivePanacheMongoEntityBase> Uni<T> update() {};    public <T extends ReactivePanacheMongoEntityBase> Uni<T> persistOrUpdate() {};}")).collect(Collectors.toList())).build());

    public String getDisplayName() {
        return "Return `Uni<T extends ReactivePanacheMongoEntityBase>` on `ReactivePanacheMongoEntityBase#persist()`";
    }

    public String getDescription() {
        return "The `persist()`, `update()`, and `persistOrUpdate()` methods now return a `Uni<T extends ReactivePanacheMongoEntityBase>` instead of a `Uni<Void>` to allow chaining the methods.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                this.doAfterVisit((TreeVisitor)new UsesMethod(PERSIST_MATCHER));
                this.doAfterVisit((TreeVisitor)new UsesMethod(UPDATE_MATCHER));
                this.doAfterVisit((TreeVisitor)new UsesMethod(PERSIST_OR_UPDATE_MATCHER));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UseReactivePanacheMongoEntityBaseUniTVisitor();
    }

    private static class UseReactivePanacheMongoEntityBaseUniTVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private UseReactivePanacheMongoEntityBaseUniTVisitor() {
        }

        private static boolean hasVoidParameterization(J.MethodInvocation method) {
            List parameterized;
            JavaType.Parameterized returnType = TypeUtils.asParameterized((JavaType)method.getReturnType());
            if (returnType != null && !(parameterized = returnType.getTypeParameters()).isEmpty()) {
                return TypeUtils.isOfClassType((JavaType)((JavaType)parameterized.get(0)), (String)"java.lang.Void");
            }
            return false;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (PERSIST_MATCHER.matches(mi)) {
                if (UseReactivePanacheMongoEntityBaseUniTVisitor.hasVoidParameterization(mi)) {
                    mi = (J.MethodInvocation)mi.withTemplate(JavaTemplate.builder(() -> ((UseReactivePanacheMongoEntityBaseUniTVisitor)this).getCursor(), (String)"#{any(io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoEntityBase)}.persist().replaceWithVoid()").javaParser(PARSER::get).build(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
                }
            } else if (UPDATE_MATCHER.matches(mi)) {
                if (UseReactivePanacheMongoEntityBaseUniTVisitor.hasVoidParameterization(mi)) {
                    mi = (J.MethodInvocation)mi.withTemplate(JavaTemplate.builder(() -> ((UseReactivePanacheMongoEntityBaseUniTVisitor)this).getCursor(), (String)"#{any(io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoEntityBase)}.update().replaceWithVoid()").javaParser(PARSER::get).build(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
                }
            } else if (PERSIST_OR_UPDATE_MATCHER.matches(mi) && UseReactivePanacheMongoEntityBaseUniTVisitor.hasVoidParameterization(mi)) {
                mi = (J.MethodInvocation)mi.withTemplate(JavaTemplate.builder(() -> ((UseReactivePanacheMongoEntityBaseUniTVisitor)this).getCursor(), (String)"#{any(io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoEntityBase)}.persistOrUpdate().replaceWithVoid()").javaParser(PARSER::get).build(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
            }
            return mi;
        }
    }
}

