/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.quarkus.quarkus2;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class UsePanacheEntityBaseUniT
extends Recipe {
    private static final MethodMatcher PERSIST_MATCHER = new MethodMatcher("io.quarkus.hibernate.reactive.panache.PanacheEntityBase persist()");
    private static final MethodMatcher PERSIST_AND_FLUSH_MATCHER = new MethodMatcher("io.quarkus.hibernate.reactive.panache.PanacheEntityBase persistAndFlush()");
    private static final ThreadLocal<JavaParser> PARSER = ThreadLocal.withInitial(() -> JavaParser.fromJavaVersion().dependsOn((Collection)Stream.of(Parser.Input.fromString((String)"package io.smallrye.mutiny;public interface Uni<T> {    Uni<Void> replaceWithVoid() {};}"), Parser.Input.fromString((String)"package io.quarkus.hibernate.reactive.panache;import io.smallrye.mutiny.Uni;public abstract class PanacheEntityBase {    public <T extends PanacheEntityBase> Uni<T> persist() {};    public <T extends PanacheEntityBase> Uni<T> persistAndFlush() {};}")).collect(Collectors.toList())).build());

    public String getDisplayName() {
        return "Use `Uni<T extends PanacheEntityBase>`";
    }

    public String getDescription() {
        return "The `persist()` and `persistAndFlush()` methods now return an `Uni<T extends PanacheEntityBase>` instead of an `Uni<Void>` to allow chaining the methods.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                this.doAfterVisit((TreeVisitor)new UsesMethod(PERSIST_MATCHER));
                this.doAfterVisit((TreeVisitor)new UsesMethod(PERSIST_AND_FLUSH_MATCHER));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UsePanacheEntityBaseUniTVisitor();
    }

    private static class UsePanacheEntityBaseUniTVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private UsePanacheEntityBaseUniTVisitor() {
        }

        private static boolean hasVoidParameterization(J.MethodInvocation method) {
            List parameterized;
            JavaType.Parameterized returnType = TypeUtils.asParameterized((JavaType)method.getReturnType());
            if (returnType != null && !(parameterized = returnType.getTypeParameters()).isEmpty()) {
                return TypeUtils.isOfClassType((JavaType)((JavaType)parameterized.get(0)), (String)"java.lang.Void");
            }
            return false;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (PERSIST_MATCHER.matches(mi)) {
                if (UsePanacheEntityBaseUniTVisitor.hasVoidParameterization(mi)) {
                    mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((UsePanacheEntityBaseUniTVisitor)this).getCursor(), (String)"#{any(io.quarkus.hibernate.reactive.panache.PanacheEntityBase)}.persist().replaceWithVoid()").javaParser(PARSER::get).build(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
                }
            } else if (PERSIST_AND_FLUSH_MATCHER.matches(mi) && UsePanacheEntityBaseUniTVisitor.hasVoidParameterization(mi)) {
                mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((UsePanacheEntityBaseUniTVisitor)this).getCursor(), (String)"#{any(io.quarkus.hibernate.reactive.panache.PanacheEntityBase)}.persistAndFlush().replaceWithVoid()").javaParser(PARSER::get).build(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
            }
            return mi;
        }
    }
}

