/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.quarkus.quarkus2;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemovePlugin;
import org.openrewrite.maven.search.FindPlugin;
import org.openrewrite.maven.tree.Maven;

public class RemoveAvroMavenPlugin
extends Recipe {
    public String getDisplayName() {
        return "Remove `avro-maven-plugin`";
    }

    public String getDescription() {
        return "Removes the `avro-maven-plugin` if the `quarkus-maven-plugin` is found in the project's `pom.xml`. Avro has been integrated with the Quarkus code generation mechanism. This replaces the need to use the Avro plugin.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new MavenVisitor(){

            public Maven visitMaven(Maven maven, ExecutionContext ctx) {
                if (!FindPlugin.find((Maven)maven, (String)"io.quarkus", (String)"quarkus-maven-plugin").isEmpty()) {
                    maven = maven.withMarkers(maven.getMarkers().searchResult());
                }
                return super.visitMaven(maven, ctx);
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveAvroMavenPluginVisitor();
    }

    private static class RemoveAvroMavenPluginVisitor
    extends MavenVisitor {
        private RemoveAvroMavenPluginVisitor() {
        }

        public Maven visitMaven(Maven maven, ExecutionContext ctx) {
            this.doAfterVisit((Recipe)new RemovePlugin("org.apache.avro", "avro-maven-plugin"));
            return super.visitMaven(maven, ctx);
        }
    }
}

