/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.quarkus;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.search.FindPlugin;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.search.FindTags;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class MigrateQuarkusMavenPluginNativeImageGoal
extends Recipe {
    public String getDisplayName() {
        return "Use `native` profile in `quarkus-maven-plugin`";
    }

    public String getDescription() {
        return "Migrates the `quarkus-maven-plugin` deprecated `native-image` goal. If the `native-image` goal needs to be removed, this adds `<quarkus.package.type>native</quarkus.package.type>` to the `native` profile `properties` section, given the `native` profile exists in the `pom.xml`.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                FindPlugin.find((Xml.Document)document, (String)"io.quarkus", (String)"quarkus-maven-plugin").forEach(plugin -> FindTags.find((Xml)plugin, (String)"//executions/execution/goals/goal").forEach(goal -> {
                    Xml.CharData existingValue;
                    if (goal.getContent() != null && goal.getContent().size() == 1 && goal.getContent().get(0) instanceof Xml.CharData && "native-image".equalsIgnoreCase((existingValue = (Xml.CharData)goal.getContent().get(0)).getText())) {
                        this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)goal, true));
                        this.doAfterVisit((TreeVisitor)new AddQuarkusPackageTypePropertyToNativeProfile());
                    }
                }));
                return super.visitDocument(document, (Object)ctx);
            }
        };
    }

    private static class AddQuarkusPackageTypePropertyToNativeProfile
    extends MavenIsoVisitor<ExecutionContext> {
        private AddQuarkusPackageTypePropertyToNativeProfile() {
        }

        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            FindTags.find((Xml)document, (String)"/project/profiles/profile").forEach(profile -> {
                String profileId;
                Optional maybeId = profile.getChild("id");
                if (maybeId.isPresent() && "native".equals(profileId = (String)((Xml.Tag)maybeId.get()).getValue().orElse(null))) {
                    Optional maybeProperties = profile.getChild("properties");
                    if (!maybeProperties.isPresent()) {
                        Xml.Tag propertiesTag = Xml.Tag.build((String)"<properties/>");
                        this.doAfterVisit((TreeVisitor)new AddToTagVisitor(profile, propertiesTag));
                        this.doAfterVisit((TreeVisitor)new AddQuarkusPackageTypePropertyToNativeProfile());
                    } else {
                        Xml.Tag profileProperties = (Xml.Tag)maybeProperties.get();
                        Optional<Xml.Tag> maybePackagingProperty = profileProperties.getChildren().stream().filter(prop -> "quarkus.package.type".equals(prop.getName())).findAny();
                        if (!maybePackagingProperty.isPresent()) {
                            Xml.Tag newVersionTag = Xml.Tag.build((String)"<quarkus.package.type>native</quarkus.package.type>");
                            this.doAfterVisit((TreeVisitor)new AddToTagVisitor(profileProperties, newVersionTag));
                        }
                    }
                }
            });
            return super.visitDocument(document, (Object)ctx);
        }
    }
}

