/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.quarkus;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class MultiTransformHotStreamToMultiHotStream
extends Recipe {
    private static final MethodMatcher HOT_STREAM_METHOD_MATCHER = new MethodMatcher("io.smallrye.mutiny.groups.MultiTransform toHotStream()");

    public String getDisplayName() {
        return "Use Mutiny `multi.toHotStream()`";
    }

    public String getDescription() {
        return "Replace Mutiny API usages of `multi.transform().toHotStream()` with `multi.toHotStream()`.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(HOT_STREAM_METHOD_MATCHER);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MultiTransformHotStreamToMultiHotStreamVisitor();
    }

    private static class MultiTransformHotStreamToMultiHotStreamVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher TRANSFORM_METHOD_MATCHER = new MethodMatcher("io.smallrye.mutiny.Multi transform()");
        private static final MethodMatcher SELECT_METHOD_MATCHER = new MethodMatcher("io.smallrye.mutiny.Multi select()");

        private MultiTransformHotStreamToMultiHotStreamVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            J.MethodInvocation mSelect;
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)executionContext);
            if (HOT_STREAM_METHOD_MATCHER.matches(mi) && mi.getSelect() != null && mi.getSelect() instanceof J.MethodInvocation && (TRANSFORM_METHOD_MATCHER.matches(mSelect = (J.MethodInvocation)mi.getSelect()) || SELECT_METHOD_MATCHER.matches(mSelect))) {
                return mi.withSelect(mSelect.getSelect());
            }
            return mi;
        }
    }
}

