/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.quarkus;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class ConfigPropertiesToConfigMapping
extends Recipe {
    public String getDisplayName() {
        return "Use `@ConfigMapping`";
    }

    public String getDescription() {
        return "Migrate Quarkus configuration classes annotated with `@ConfigProperties` to the equivalent Smallrye `@ConfigMapping`.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new UsesType("io.quarkus.arc.config.ConfigProperties");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ConfigPropertiesToConfigMappingVisitor();
    }

    private static class ConfigPropertiesToConfigMappingVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final AnnotationMatcher CONFIG_PROPERTIES_ANNOTATION_MATCHER = new AnnotationMatcher("@io.quarkus.arc.config.ConfigProperties");

        private ConfigPropertiesToConfigMappingVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)executionContext);
            if (cd.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)CONFIG_PROPERTIES_ANNOTATION_MATCHER).matches(arg_0)) && cd.getKind().equals((Object)J.ClassDeclaration.Kind.Type.Interface)) {
                this.doAfterVisit((Recipe)new ChangeType("io.quarkus.arc.config.ConfigProperties", "io.smallrye.config.ConfigMapping", Boolean.valueOf(true)));
            }
            return cd;
        }
    }
}

