/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.quarkus;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.quarkus.AddQuarkusMavenPluginGoalVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.search.FindPlugin;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ConfigureQuarkusMavenPluginWithReasonableDefaults
extends Recipe {
    public String getDisplayName() {
        return "Configure `quarkus-maven-plugin` with reasonable defaults";
    }

    public String getDescription() {
        return "Configures the `quarkus-maven-plugin` with reasonable defaults, such as default activated `goals` and `<extensions>` configuration.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ConfigureQuarkusMavenPluginWithReasonableDefaultsVisitor();
    }

    @NonNull
    public String toString() {
        return "ConfigureQuarkusMavenPluginWithReasonableDefaults()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigureQuarkusMavenPluginWithReasonableDefaults)) {
            return false;
        }
        ConfigureQuarkusMavenPluginWithReasonableDefaults other = (ConfigureQuarkusMavenPluginWithReasonableDefaults)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ConfigureQuarkusMavenPluginWithReasonableDefaults;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static class ConfigureQuarkusMavenPluginWithReasonableDefaultsVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private ConfigureQuarkusMavenPluginWithReasonableDefaultsVisitor() {
        }

        public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
            this.doAfterVisit((TreeVisitor)new AddQuarkusMavenPluginGoalVisitor("build"));
            this.doAfterVisit((TreeVisitor)new AddQuarkusMavenPluginGoalVisitor("generate-code"));
            this.doAfterVisit((TreeVisitor)new AddQuarkusMavenPluginGoalVisitor("generate-code-tests"));
            FindPlugin.find((Xml.Document)document, (String)"io.quarkus", (String)"quarkus-maven-plugin").forEach(plugin -> {
                Optional maybeExtensions = plugin.getChild("extensions");
                if (!maybeExtensions.isPresent()) {
                    Xml.Tag extensionsTag = Xml.Tag.build((String)"<extensions>true</extensions>");
                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor(plugin, extensionsTag));
                } else {
                    this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)maybeExtensions.get(), "true"));
                }
            });
            return document;
        }
    }
}

