/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.quarkus2;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class UsePanacheEntityBaseUniT
extends Recipe {
    private static final MethodMatcher PERSIST_MATCHER = new MethodMatcher("io.quarkus.hibernate.reactive.panache.PanacheEntityBase persist()");
    private static final MethodMatcher PERSIST_AND_FLUSH_MATCHER = new MethodMatcher("io.quarkus.hibernate.reactive.panache.PanacheEntityBase persistAndFlush()");
    private static final JavaParser.Builder<?, ?> PARSER = JavaParser.fromJavaVersion().dependsOn((Collection)Stream.of(Parser.Input.fromString((String)"package io.smallrye.mutiny;public interface Uni<T> {    Uni<Void> replaceWithVoid() {};}"), Parser.Input.fromString((String)"package io.quarkus.hibernate.reactive.panache;import io.smallrye.mutiny.Uni;public abstract class PanacheEntityBase {    public <T extends PanacheEntityBase> Uni<T> persist() {};    public <T extends PanacheEntityBase> Uni<T> persistAndFlush() {};}")).collect(Collectors.toList()));

    public String getDisplayName() {
        return "Use `Uni<T extends PanacheEntityBase>`";
    }

    public String getDescription() {
        return "The `persist()` and `persistAndFlush()` methods now return an `Uni<T extends PanacheEntityBase>` instead of an `Uni<Void>` to allow chaining the methods.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(PERSIST_MATCHER), new UsesMethod(PERSIST_AND_FLUSH_MATCHER)}), (TreeVisitor)new UsePanacheEntityBaseUniTVisitor());
    }

    private static class UsePanacheEntityBaseUniTVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private UsePanacheEntityBaseUniTVisitor() {
        }

        private static boolean hasVoidParameterization(J.MethodInvocation method) {
            List parameterized;
            JavaType.Parameterized returnType = TypeUtils.asParameterized((JavaType)method.getType());
            if (returnType != null && !(parameterized = returnType.getTypeParameters()).isEmpty()) {
                return TypeUtils.isOfClassType((JavaType)((JavaType)parameterized.get(0)), (String)"java.lang.Void");
            }
            return false;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (PERSIST_MATCHER.matches(mi)) {
                if (UsePanacheEntityBaseUniTVisitor.hasVoidParameterization(mi)) {
                    mi = (J.MethodInvocation)JavaTemplate.builder((String)"#{any(io.quarkus.hibernate.reactive.panache.PanacheEntityBase)}.persist().replaceWithVoid()").javaParser(PARSER).build().apply(new Cursor(this.getCursor().getParent(), (Object)mi), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
                }
            } else if (PERSIST_AND_FLUSH_MATCHER.matches(mi) && UsePanacheEntityBaseUniTVisitor.hasVoidParameterization(mi)) {
                mi = (J.MethodInvocation)JavaTemplate.builder((String)"#{any(io.quarkus.hibernate.reactive.panache.PanacheEntityBase)}.persistAndFlush().replaceWithVoid()").javaParser(PARSER).build().apply(new Cursor(this.getCursor().getParent(), (Object)mi), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
            }
            return mi;
        }
    }
}

