/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.search;

import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.properties.PropertiesIsoVisitor;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.quarkus.QuarkusExecutionContextView;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;

public final class FindQuarkusProperties
extends Recipe {
    @Option(displayName="Property key", description="The property key to look for.", example="quarkus.http.port")
    private final String propertyKey;
    @Option(displayName="Profile", description="The profile where the property is defined. If not specified, the property will be searched on all profiles.", required=false, example="dev")
    private final @Nullable String profile;
    @Option(displayName="Search on all Profiles", description="If set, the property will be searched on all available profiles. Defaults to `true` if the profile is not defined.", required=false, example="false")
    private final @Nullable Boolean searchAllProfiles;
    @Option(displayName="Optional list of file path matcher", description="Each value in this list represents a glob expression that is used to match which files will be modified. If this value is not present, this recipe will query the execution context for reasonable defaults. (\"**/application.yml\", \"**/application.yaml\", \"**/application.properties\" and \"**/META-INF/microprofile-config.properties\".", required=false, example="[\"**/application.yaml\"]")
    private final @Nullable List<String> pathExpressions;

    public String getDisplayName() {
        return "Find Quarkus property";
    }

    public String getDescription() {
        return "Finds occurrences of a Quarkus property key.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate().and(Validated.notBlank((String)"propertyKey", (String)this.propertyKey));
        if (StringUtils.isNotEmpty((String)this.profile)) {
            validated = validated.and(Validated.test((String)"searchAllProfiles", (String)"cannot be used together with profile", (Object)this.searchAllProfiles, x -> x == null || x == false));
        }
        return validated;
    }

    public static Set<Properties.Entry> find(Properties properties, String propertyKey, @Nullable String profile, @Nullable Boolean searchAllProfiles) {
        final Pattern pattern = Pattern.compile(FindQuarkusProperties.getSearchRegex(propertyKey, profile, searchAllProfiles));
        PropertiesIsoVisitor<Set<Properties.Entry>> findVisitor = new PropertiesIsoVisitor<Set<Properties.Entry>>(){

            public Properties.Entry visitEntry(Properties.Entry entry, Set<Properties.Entry> ps) {
                if (pattern.matcher(entry.getKey()).find()) {
                    ps.add((Properties.Entry)SearchResult.found((Tree)entry));
                }
                return super.visitEntry(entry, ps);
            }
        };
        TreeSet<Properties.Entry> entries = new TreeSet<Properties.Entry>(Comparator.comparing(Properties.Entry::getKey));
        findVisitor.visit((Tree)properties, entries);
        return entries;
    }

    public static Set<Yaml.Mapping.Entry> find(Yaml.Documents yaml, String propertyKey, @Nullable String profile, @Nullable Boolean searchAllProfiles) {
        final Pattern pattern = Pattern.compile(FindQuarkusProperties.getSearchRegex(propertyKey, profile, searchAllProfiles));
        YamlIsoVisitor<Set<Yaml.Mapping.Entry>> findVisitor = new YamlIsoVisitor<Set<Yaml.Mapping.Entry>>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, Set<Yaml.Mapping.Entry> entries) {
                entry = super.visitMappingEntry(entry, entries);
                String prop = FindQuarkusProperties.getProperty(this.getCursor());
                if (pattern.matcher(prop).find()) {
                    YamlKey newKey = entry.getKey().copyPaste();
                    if (newKey instanceof Yaml.Scalar) {
                        newKey = ((Yaml.Scalar)newKey).withValue(prop);
                    }
                    entries.add((Yaml.Mapping.Entry)SearchResult.found((Tree)entry.copyPaste().withKey(newKey)));
                }
                return entry;
            }
        };
        TreeSet<Yaml.Mapping.Entry> entries = new TreeSet<Yaml.Mapping.Entry>((o1, o2) -> {
            if (o1.getKey() instanceof Yaml.Scalar && o2.getKey() instanceof Yaml.Scalar) {
                return o1.getKey().getValue().compareTo(o2.getKey().getValue());
            }
            return 0;
        });
        findVisitor.visit((Tree)yaml, entries);
        return entries;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern pattern = Pattern.compile(FindQuarkusProperties.getSearchRegex(this.propertyKey, this.profile, this.searchAllProfiles));
        return new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                QuarkusExecutionContextView quarkusCtx = QuarkusExecutionContextView.view(ctx);
                return quarkusCtx.isQuarkusConfigFile((Tree)sourceFile, FindQuarkusProperties.this.pathExpressions);
            }

            public @Nullable Tree visit(@Nullable Tree t, ExecutionContext ctx) {
                if (t instanceof Yaml.Documents) {
                    t = new YamlIsoVisitor<ExecutionContext>(){

                        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                            entry = super.visitMappingEntry(entry, (Object)ctx);
                            String prop = FindQuarkusProperties.getProperty(this.getCursor());
                            if (pattern.matcher(prop).find()) {
                                entry = (Yaml.Mapping.Entry)SearchResult.found((Tree)entry);
                            }
                            return entry;
                        }
                    }.visit(t, (Object)ctx);
                } else if (t instanceof Properties.File) {
                    t = new PropertiesVisitor<ExecutionContext>(){

                        public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                            if (pattern.matcher(entry.getKey()).find()) {
                                entry = (Properties.Entry)SearchResult.found((Tree)entry);
                            }
                            return super.visitEntry(entry, (Object)ctx);
                        }
                    }.visit(t, (Object)ctx);
                }
                return t;
            }
        };
    }

    private static String getSearchRegex(String propertyKey, @Nullable String profile, @Nullable Boolean searchAllProfiles) {
        if (!Boolean.FALSE.equals(searchAllProfiles)) {
            return "^(?:%[\\w\\-_,]+\\.)?" + propertyKey + "$";
        }
        if (StringUtils.isNotEmpty((String)profile)) {
            return "^%[\\w\\-_,]*(?:" + profile + ")[\\w\\-_,]*\\." + propertyKey + "$";
        }
        return "^" + propertyKey + "$";
    }

    static String getProperty(Cursor cursor) {
        StringBuilder asProperty = new StringBuilder();
        Iterator path = cursor.getPath();
        int i = 0;
        while (path.hasNext()) {
            Object next = path.next();
            if (!(next instanceof Yaml.Mapping.Entry)) continue;
            Yaml.Mapping.Entry entry = (Yaml.Mapping.Entry)next;
            if (i++ > 0) {
                asProperty.insert(0, '.');
            }
            asProperty.insert(0, entry.getKey().getValue());
        }
        return asProperty.toString();
    }

    @ConstructorProperties(value={"propertyKey", "profile", "searchAllProfiles", "pathExpressions"})
    @Generated
    public FindQuarkusProperties(String propertyKey, @Nullable String profile, @Nullable Boolean searchAllProfiles, @Nullable List<String> pathExpressions) {
        this.propertyKey = propertyKey;
        this.profile = profile;
        this.searchAllProfiles = searchAllProfiles;
        this.pathExpressions = pathExpressions;
    }

    @Generated
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Generated
    public @Nullable String getProfile() {
        return this.profile;
    }

    @Generated
    public @Nullable Boolean getSearchAllProfiles() {
        return this.searchAllProfiles;
    }

    @Generated
    public @Nullable List<String> getPathExpressions() {
        return this.pathExpressions;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindQuarkusProperties(propertyKey=" + this.getPropertyKey() + ", profile=" + this.getProfile() + ", searchAllProfiles=" + this.getSearchAllProfiles() + ", pathExpressions=" + this.getPathExpressions() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindQuarkusProperties)) {
            return false;
        }
        FindQuarkusProperties other = (FindQuarkusProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$searchAllProfiles = this.getSearchAllProfiles();
        Boolean other$searchAllProfiles = other.getSearchAllProfiles();
        if (this$searchAllProfiles == null ? other$searchAllProfiles != null : !((Object)this$searchAllProfiles).equals(other$searchAllProfiles)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        List<String> this$pathExpressions = this.getPathExpressions();
        List<String> other$pathExpressions = other.getPathExpressions();
        return !(this$pathExpressions == null ? other$pathExpressions != null : !((Object)this$pathExpressions).equals(other$pathExpressions));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindQuarkusProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $searchAllProfiles = this.getSearchAllProfiles();
        result = result * 59 + ($searchAllProfiles == null ? 43 : ((Object)$searchAllProfiles).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        List<String> $pathExpressions = this.getPathExpressions();
        result = result * 59 + ($pathExpressions == null ? 43 : ((Object)$pathExpressions).hashCode());
        return result;
    }
}

