/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.AddProperty;
import org.openrewrite.properties.ChangePropertyKey;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.quarkus.QuarkusExecutionContextView;
import org.openrewrite.quarkus.QuarkusProfileUtils;
import org.openrewrite.quarkus.search.FindQuarkusProperties;
import org.openrewrite.yaml.DeleteProperty;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.tree.Yaml;

class ChangeQuarkusPropertyKeyVisitor
extends TreeVisitor<Tree, ExecutionContext> {
    final String oldPropertyKey;
    final String newPropertyKey;
    @Nullable
    final String profile;
    @Nullable
    final Boolean changeAllProfiles;
    @Nullable
    final List<String> pathExpressions;

    public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
        QuarkusExecutionContextView quarkusCtx = QuarkusExecutionContextView.view(ctx);
        return quarkusCtx.isQuarkusConfigFile((Tree)sourceFile, this.pathExpressions);
    }

    @Nullable
    public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
        if (tree instanceof Properties.File) {
            return this.visitPropertiesFile(tree, ctx);
        }
        if (tree instanceof Yaml.Documents) {
            return this.visitYamlDocuments(tree, ctx);
        }
        return tree;
    }

    @Nullable
    private Tree visitPropertiesFile(Tree tree, ExecutionContext ctx) {
        Set<Properties.Entry> existingProperties = FindQuarkusProperties.find((Properties)tree, this.oldPropertyKey, this.profile, this.changeAllProfiles);
        for (Properties.Entry entry : existingProperties) {
            String keyWithoutProfile = QuarkusProfileUtils.getKeyWithoutProfile(entry.getKey());
            String transformedKey = ChangeQuarkusPropertyKeyVisitor.replaceRegex(this.oldPropertyKey, this.newPropertyKey, keyWithoutProfile);
            CharSequence[] profiles = QuarkusProfileUtils.getProfilesFromPropertyKey(entry.getKey());
            if (profiles.length == 0 || !Boolean.FALSE.equals(this.changeAllProfiles)) {
                String newKey = profiles.length == 0 ? transformedKey : "%" + String.join((CharSequence)",", profiles) + "." + transformedKey;
                tree = new ChangePropertyKey(entry.getKey(), newKey, Boolean.valueOf(false), Boolean.valueOf(false)).getVisitor().visit(tree, (Object)ctx);
                continue;
            }
            tree = new org.openrewrite.properties.DeleteProperty(entry.getKey(), Boolean.valueOf(false)).getVisitor().visit(tree, (Object)ctx);
            ArrayList<CharSequence> remainingProfiles = new ArrayList<CharSequence>(existingProperties.size());
            for (CharSequence profile : profiles) {
                if (((String)profile).equals(this.profile)) continue;
                remainingProfiles.add(profile);
            }
            String key = "%" + this.profile + "." + transformedKey;
            tree = new AddProperty(key, entry.getValue().getText(), null, null).getVisitor().visit(tree, (Object)ctx);
            if (remainingProfiles.isEmpty()) continue;
            key = "%" + String.join((CharSequence)",", remainingProfiles) + "." + keyWithoutProfile;
            tree = new AddProperty(key, entry.getValue().getText(), null, null).getVisitor().visit(tree, (Object)ctx);
        }
        return tree;
    }

    @Nullable
    private Tree visitYamlDocuments(Tree tree, ExecutionContext ctx) {
        Set<Yaml.Mapping.Entry> existingProperties = FindQuarkusProperties.find((Yaml.Documents)tree, this.oldPropertyKey, this.profile, this.changeAllProfiles);
        for (Yaml.Mapping.Entry entry : existingProperties) {
            String[] stringArray;
            String originalEntryValue = ((Yaml.Scalar)entry.getValue()).getValue();
            String originalKey = entry.getKey().getValue();
            String keyWithoutProfile = QuarkusProfileUtils.getKeyWithoutProfile(originalKey);
            String transformedKey = ChangeQuarkusPropertyKeyVisitor.replaceRegex(this.oldPropertyKey, this.newPropertyKey, keyWithoutProfile);
            String[] profiles = QuarkusProfileUtils.getProfilesFromPropertyKey(originalKey);
            if (profiles.length == 0 || !Boolean.FALSE.equals(this.changeAllProfiles)) {
                tree = ChangeQuarkusPropertyKeyVisitor.replaceYamlKey(tree, ctx, originalKey, transformedKey, originalEntryValue, profiles);
                continue;
            }
            ArrayList<String> remainingProfiles = new ArrayList<String>(existingProperties.size());
            for (String profile : profiles) {
                if (profile.equals(this.profile)) continue;
                remainingProfiles.add(profile);
            }
            if (this.profile != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.profile;
            } else {
                stringArray = new String[]{};
            }
            tree = ChangeQuarkusPropertyKeyVisitor.replaceYamlKey(tree, ctx, originalKey, transformedKey, originalEntryValue, stringArray);
            if (remainingProfiles.isEmpty()) continue;
            tree = new MergeYaml("$", QuarkusProfileUtils.formatKey(keyWithoutProfile, originalEntryValue, String.join((CharSequence)",", remainingProfiles)), Boolean.valueOf(false), null).getVisitor().visit(tree, (Object)ctx);
        }
        return tree;
    }

    private static String replaceRegex(String oldRegex, String newRegex, String input) {
        Matcher matcher = Pattern.compile(oldRegex).matcher(input);
        if (matcher.find()) {
            StringBuffer result = new StringBuffer();
            do {
                matcher.appendReplacement(result, newRegex);
            } while (matcher.find());
            matcher.appendTail(result);
            return result.toString();
        }
        return input;
    }

    @Nullable
    private static Tree replaceYamlKey(@Nullable Tree tree, ExecutionContext ctx, String oldKey, String newKey, String value, String[] profiles) {
        if (tree == null) {
            return null;
        }
        Tree t = new DeleteProperty(oldKey, Boolean.valueOf(false), null).getVisitor().visit(tree, (Object)ctx);
        return new MergeYaml("$", QuarkusProfileUtils.formatKey(newKey, value, String.join((CharSequence)",", profiles)), Boolean.valueOf(false), null).getVisitor().visit(t, (Object)ctx);
    }

    @ConstructorProperties(value={"oldPropertyKey", "newPropertyKey", "profile", "changeAllProfiles", "pathExpressions"})
    public ChangeQuarkusPropertyKeyVisitor(String oldPropertyKey, String newPropertyKey, @Nullable String profile, @Nullable Boolean changeAllProfiles, @Nullable List<String> pathExpressions) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPropertyKey = newPropertyKey;
        this.profile = profile;
        this.changeAllProfiles = changeAllProfiles;
        this.pathExpressions = pathExpressions;
    }
}

