/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus;

import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.yaml.tree.Yaml;

public class QuarkusExecutionContextView
extends DelegatingExecutionContext {
    private static final String DEFAULT_APPLICATION_CONFIGURATION_PATHS = "org.openrewrite.java.quarkus.defaultApplicationConfigurationPaths";

    public QuarkusExecutionContextView(ExecutionContext delegate) {
        super(delegate);
    }

    public static QuarkusExecutionContextView view(ExecutionContext ctx) {
        if (ctx instanceof QuarkusExecutionContextView) {
            return (QuarkusExecutionContextView)ctx;
        }
        return new QuarkusExecutionContextView(ctx);
    }

    public QuarkusExecutionContextView setDefaultApplicationConfigurationPaths(List<String> pathExpressions) {
        this.putMessage(DEFAULT_APPLICATION_CONFIGURATION_PATHS, pathExpressions);
        return this;
    }

    public List<String> getDefaultApplicationConfigurationPaths() {
        return (List)this.getMessage(DEFAULT_APPLICATION_CONFIGURATION_PATHS, Arrays.asList("**/application.{properties,yaml,yml}", "**/META-INF/microprofile-config.properties"));
    }

    public boolean isQuarkusConfigFile(Tree tree, @Nullable List<String> pathExpressions) {
        List<String> expressions;
        if (!(tree instanceof Properties.File) && !(tree instanceof Yaml.Documents)) {
            return false;
        }
        List<String> list = expressions = pathExpressions != null ? pathExpressions : Collections.emptyList();
        if (expressions.isEmpty()) {
            expressions = this.getDefaultApplicationConfigurationPaths();
        }
        for (String filePattern : expressions) {
            if (!FileSystems.getDefault().getPathMatcher("glob:" + filePattern).matches(((SourceFile)tree).getSourcePath())) continue;
            return true;
        }
        return false;
    }
}

