/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.search;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.properties.PropertiesIsoVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.quarkus.QuarkusExecutionContextView;
import org.openrewrite.quarkus.search.FindQuarkusProperties;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindQuarkusProfiles
extends Recipe {
    public String getDisplayName() {
        return "Search Quarkus profiles";
    }

    public String getDescription() {
        return "Search the properties for existing Quarkus profiles.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                QuarkusExecutionContextView quarkusCtx = QuarkusExecutionContextView.view(ctx);
                return quarkusCtx.isQuarkusConfigFile((Tree)sourceFile, null);
            }

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if ((tree = super.visit(tree, (Object)ctx)) instanceof Properties.File) {
                    this.doAfterVisit((TreeVisitor)new PropertiesIsoVisitor<ExecutionContext>(){

                        public Properties.Entry visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                            entry = super.visitEntry(entry, (Object)ctx);
                            entry = entry.withValue(entry.getValue().withMarkers(entry.getValue().getMarkers().computeByType((Marker)new SearchResult(Tree.randomId(), null), (s1, s2) -> s1 == null ? s2 : s1)));
                            return super.visitEntry(entry, (Object)ctx);
                        }
                    });
                } else if (tree instanceof Yaml.Documents) {
                    this.doAfterVisit((TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

                        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                            entry = super.visitMappingEntry(entry, (Object)ctx);
                            entry = entry.withValue((Yaml.Block)entry.getValue().withMarkers(entry.getValue().getMarkers().computeByType((Marker)new SearchResult(Tree.randomId(), null), (s1, s2) -> s1 == null ? s2 : s1)));
                            return super.visitMappingEntry(entry, (Object)ctx);
                        }
                    });
                }
                return tree;
            }
        };
    }

    public static Set<String> find(Tree tree) {
        final HashSet<String> profiles = new HashSet<String>();
        new TreeVisitor<Tree, Set<String>>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, Set<String> ctx) {
                if ((tree = super.visit(tree, ctx)) instanceof Properties.File) {
                    Properties.File propertiesFile = (Properties.File)tree;
                    new PropertiesIsoVisitor<Set<String>>(){

                        public Properties.Entry visitEntry(Properties.Entry entry, Set<String> ctx) {
                            entry = super.visitEntry(entry, ctx);
                            FindQuarkusProfiles.addProfile(entry.getKey(), ctx);
                            return entry;
                        }
                    }.reduce((Tree)propertiesFile, (Object)profiles);
                } else if (tree instanceof Yaml.Documents) {
                    new YamlIsoVisitor<Set<String>>(){

                        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, Set<String> ctx) {
                            entry = super.visitMappingEntry(entry, ctx);
                            String prop = FindQuarkusProperties.getProperty(this.getCursor());
                            FindQuarkusProfiles.addProfile(prop, ctx);
                            return entry;
                        }
                    }.reduce(tree, (Object)profiles);
                }
                return tree;
            }
        }.visit(tree, profiles);
        return profiles;
    }

    private static void addProfile(String propertyKey, Set<String> profiles) {
        if (propertyKey.isEmpty() || propertyKey.charAt(0) != '%') {
            return;
        }
        int index = propertyKey.indexOf(46);
        if (index == -1) {
            return;
        }
        String temp = propertyKey.substring(1, index);
        profiles.addAll(Arrays.asList(temp.split(",")));
    }

    @NonNull
    public String toString() {
        return "FindQuarkusProfiles()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindQuarkusProfiles)) {
            return false;
        }
        FindQuarkusProfiles other = (FindQuarkusProfiles)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindQuarkusProfiles;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

