/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.quarkus.ChangeQuarkusPropertyValueVisitor;
import org.openrewrite.quarkus.search.FindQuarkusProperties;

public final class ChangeQuarkusPropertyValue
extends Recipe {
    @Option(displayName="Property key", description="The name of the property key whose value is to be changed. Supports regex.", example="quarkus.hibernate-search-orm.indexing.plan.synchronization.strategy")
    private final String propertyKey;
    @Option(displayName="New value", description="The new value to be used for key specified by `propertyKey`.", example="read-sync")
    private final String newValue;
    @Option(displayName="Old value", required=false, description="Only change the property value if it matches the configured `oldValue`.", example="read-sync")
    private final @Nullable String oldValue;
    @Option(displayName="Profile", description="The profile where the property is defined. If not specified, the property will be changed on all profiles by default.", required=false, example="dev")
    private final @Nullable String profile;
    @Option(displayName="Change for all profiles", description="If set to true, the property value will be changed on all available profiles. Defaults to `true` if a profile is not defined.", required=false, example="false")
    private final @Nullable Boolean changeAllProfiles;
    @Option(displayName="Optional list of file path matcher", description="Each value in this list represents a glob expression that is used to match which files will be modified. If this value is not present, this recipe will query the execution context for reasonable defaults. (\"**/application.yml\", \"**/application.yaml\", \"**/application.properties\" and \"**/META-INF/microprofile-config.properties\".", required=false, example="[\"**/application.yaml\"]")
    private final @Nullable List<String> pathExpressions;

    public Validated<Object> validate() {
        Validated validated = super.validate().and(Validated.notBlank((String)"propertyKey", (String)this.propertyKey));
        if (StringUtils.isNotEmpty((String)this.profile)) {
            validated = validated.and(Validated.test((String)"changeAllProfiles", (String)"cannot be used together with profile", (Object)this.changeAllProfiles, x -> x == null || x == false));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Change Quarkus configuration property value";
    }

    public String getDescription() {
        return "Change the value of a property in Quarkus configuration files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindQuarkusProperties(this.propertyKey, this.profile, this.changeAllProfiles, this.pathExpressions).getVisitor(), (TreeVisitor)new ChangeQuarkusPropertyValueVisitor(this.propertyKey, this.newValue, this.oldValue, this.profile, this.changeAllProfiles, this.pathExpressions));
    }

    @ConstructorProperties(value={"propertyKey", "newValue", "oldValue", "profile", "changeAllProfiles", "pathExpressions"})
    @Generated
    public ChangeQuarkusPropertyValue(String propertyKey, String newValue, @Nullable String oldValue, @Nullable String profile, @Nullable Boolean changeAllProfiles, @Nullable List<String> pathExpressions) {
        this.propertyKey = propertyKey;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.profile = profile;
        this.changeAllProfiles = changeAllProfiles;
        this.pathExpressions = pathExpressions;
    }

    @Generated
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Generated
    public String getNewValue() {
        return this.newValue;
    }

    @Generated
    public @Nullable String getOldValue() {
        return this.oldValue;
    }

    @Generated
    public @Nullable String getProfile() {
        return this.profile;
    }

    @Generated
    public @Nullable Boolean getChangeAllProfiles() {
        return this.changeAllProfiles;
    }

    @Generated
    public @Nullable List<String> getPathExpressions() {
        return this.pathExpressions;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeQuarkusPropertyValue(propertyKey=" + this.getPropertyKey() + ", newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ", profile=" + this.getProfile() + ", changeAllProfiles=" + this.getChangeAllProfiles() + ", pathExpressions=" + this.getPathExpressions() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeQuarkusPropertyValue)) {
            return false;
        }
        ChangeQuarkusPropertyValue other = (ChangeQuarkusPropertyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$changeAllProfiles = this.getChangeAllProfiles();
        Boolean other$changeAllProfiles = other.getChangeAllProfiles();
        if (this$changeAllProfiles == null ? other$changeAllProfiles != null : !((Object)this$changeAllProfiles).equals(other$changeAllProfiles)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        List<String> this$pathExpressions = this.getPathExpressions();
        List<String> other$pathExpressions = other.getPathExpressions();
        return !(this$pathExpressions == null ? other$pathExpressions != null : !((Object)this$pathExpressions).equals(other$pathExpressions));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeQuarkusPropertyValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $changeAllProfiles = this.getChangeAllProfiles();
        result = result * 59 + ($changeAllProfiles == null ? 43 : ((Object)$changeAllProfiles).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        List<String> $pathExpressions = this.getPathExpressions();
        result = result * 59 + ($pathExpressions == null ? 43 : ((Object)$pathExpressions).hashCode());
        return result;
    }
}

