/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.properties.AddProperty;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.quarkus.QuarkusExecutionContextView;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.tree.Yaml;

public final class AddQuarkusProperty
extends Recipe {
    @Option(displayName="Property key", description="The property key to add.", example="quarkus.http.port")
    private final String property;
    @Option(displayName="Property value", description="The value of the new property key.", example="9090")
    private final String value;
    @Option(displayName="Optional comment to be prepended to the property", description="A comment that will be added to the new property.", required=false, example="This is a comment")
    private final @Nullable String comment;
    @Option(displayName="Profile", description="The profile to add the property to. If not specified, the property will be added to the default profile.", required=false, example="dev")
    private final @Nullable String profile;
    @Option(displayName="Optional list of file path matcher", description="Each value in this list represents a glob expression that is used to match which files will be modified. If this value is not present, this recipe will query the execution context for reasonable defaults. (\"**/application.yml\", \"**/application.yaml\", \"**/application.properties\" and \"**/META-INF/microprofile-config.properties\".", required=false, example="[\"**/application.yaml\"]")
    private final @Nullable List<String> pathExpressions;
    private static final Pattern scalarNeedsAQuote = Pattern.compile("[^a-zA-Z\\d\\s]+");

    public String getDisplayName() {
        return "Add a Quarkus configuration property";
    }

    public String getDescription() {
        return "Add a Quarkus configuration property to an existing configuration file if it does not already exist in that file.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                QuarkusExecutionContextView quarkusCtx = QuarkusExecutionContextView.view(ctx);
                return quarkusCtx.isQuarkusConfigFile((Tree)sourceFile, AddQuarkusProperty.this.pathExpressions);
            }

            public @Nullable Tree visit(@Nullable Tree t, ExecutionContext ctx) {
                if (t instanceof Yaml.Documents) {
                    t = AddQuarkusProperty.this.createMergeYamlVisitor().getVisitor().visit(t, (Object)ctx);
                } else if (t instanceof Properties.File) {
                    t = new AddProperty(AddQuarkusProperty.propertyName(AddQuarkusProperty.this.property, AddQuarkusProperty.this.profile), AddQuarkusProperty.this.value, AddQuarkusProperty.this.comment, null, null).getVisitor().visit(t, (Object)ctx);
                }
                return t;
            }
        };
    }

    private MergeYaml createMergeYamlVisitor() {
        String[] propertyParts = AddQuarkusProperty.yamlPropertyName(this.property, this.profile).split("\\.");
        StringBuilder yaml = new StringBuilder();
        String indent = "";
        for (String part : propertyParts) {
            if (yaml.length() > 0) {
                yaml.append("\n");
            }
            if (!StringUtils.isBlank((String)this.comment) && part == propertyParts[propertyParts.length - 1]) {
                yaml.append(indent).append("# ").append(this.comment).append("\n");
            }
            yaml.append(indent).append(part).append(":");
            indent = indent + "  ";
        }
        if (this.quoteValue(this.value)) {
            yaml.append(" \"").append(this.value).append('\"');
        } else {
            yaml.append(" ").append(this.value);
        }
        return new MergeYaml("$", yaml.toString(), Boolean.valueOf(true), null, null, null, null, null);
    }

    private boolean quoteValue(String value) {
        return scalarNeedsAQuote.matcher(value).matches();
    }

    private static String propertyName(String name, @Nullable String profile) {
        return profile == null ? name : "%" + profile + "." + name;
    }

    private static String yamlPropertyName(String name, @Nullable String profile) {
        return profile == null ? name : "\"%" + profile + "\"." + name;
    }

    @ConstructorProperties(value={"property", "value", "comment", "profile", "pathExpressions"})
    @Generated
    public AddQuarkusProperty(String property, String value, @Nullable String comment, @Nullable String profile, @Nullable List<String> pathExpressions) {
        this.property = property;
        this.value = value;
        this.comment = comment;
        this.profile = profile;
        this.pathExpressions = pathExpressions;
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public @Nullable String getComment() {
        return this.comment;
    }

    @Generated
    public @Nullable String getProfile() {
        return this.profile;
    }

    @Generated
    public @Nullable List<String> getPathExpressions() {
        return this.pathExpressions;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddQuarkusProperty(property=" + this.getProperty() + ", value=" + this.getValue() + ", comment=" + this.getComment() + ", profile=" + this.getProfile() + ", pathExpressions=" + this.getPathExpressions() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddQuarkusProperty)) {
            return false;
        }
        AddQuarkusProperty other = (AddQuarkusProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        List<String> this$pathExpressions = this.getPathExpressions();
        List<String> other$pathExpressions = other.getPathExpressions();
        return !(this$pathExpressions == null ? other$pathExpressions != null : !((Object)this$pathExpressions).equals(other$pathExpressions));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddQuarkusProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        List<String> $pathExpressions = this.getPathExpressions();
        result = result * 59 + ($pathExpressions == null ? 43 : ((Object)$pathExpressions).hashCode());
        return result;
    }
}

