/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus;

import java.beans.ConstructorProperties;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.quarkus.DeleteQuarkusPropertyVisitor;
import org.openrewrite.quarkus.search.FindQuarkusProperties;

public final class DeleteQuarkusProperty
extends Recipe {
    @Option(displayName="Property key", description="The name of the property key whose value is to be deleted.", example="quarkus.hibernate-search-orm.indexing.plan.synchronization.strategy")
    private final String propertyKey;
    @Option(displayName="Old value", required=false, description="Only delete the property value if it matches the configured `oldValue`.", example="read-sync")
    @Nullable
    private final String oldValue;
    @Option(displayName="Profile", description="The profile where the property should be deleted. If not specified, the property will be deleted from all profiles by default.", required=false, example="dev")
    @Nullable
    private final String profile;
    @Option(displayName="Delete from all profiles", description="If set to true, the property will be removed from all available profiles. Defaults to `true`.", required=false, example="false")
    @Nullable
    private final Boolean deleteFromAllProfiles;
    @Option(displayName="Optional list of file path matcher", description="Each value in this list represents a glob expression that is used to match which files will be modified. If this value is not present, this recipe will query the execution context for reasonable defaults. (\"**/application.yml\", \"**/application.yaml\", \"**/application.properties\" and \"**/META-INF/microprofile-config.properties\".", required=false, example="[\"**/application.yaml\"]")
    @Nullable
    private final List<String> pathExpressions;

    public Validated<Object> validate() {
        Validated validated = super.validate().and(Validated.notBlank((String)"propertyKey", (String)this.propertyKey));
        if (StringUtils.isNotEmpty((String)this.profile)) {
            validated = validated.and(Validated.test((String)"deleteFromAllProfiles", (String)"cannot be used together with profile", (Object)this.deleteFromAllProfiles, x -> x == null || x == false));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Delete Quarkus configuration property";
    }

    public String getDescription() {
        return "Delete a property from Quarkus configuration files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindQuarkusProperties(this.propertyKey, this.profile, this.deleteFromAllProfiles).getVisitor(), (TreeVisitor)new DeleteQuarkusPropertyVisitor(this.propertyKey, this.oldValue, this.profile, this.deleteFromAllProfiles, this.pathExpressions));
    }

    @ConstructorProperties(value={"propertyKey", "oldValue", "profile", "deleteFromAllProfiles", "pathExpressions"})
    public DeleteQuarkusProperty(String propertyKey, @Nullable String oldValue, @Nullable String profile, @Nullable Boolean deleteFromAllProfiles, @Nullable List<String> pathExpressions) {
        this.propertyKey = propertyKey;
        this.oldValue = oldValue;
        this.profile = profile;
        this.deleteFromAllProfiles = deleteFromAllProfiles;
        this.pathExpressions = pathExpressions;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Nullable
    public String getOldValue() {
        return this.oldValue;
    }

    @Nullable
    public String getProfile() {
        return this.profile;
    }

    @Nullable
    public Boolean getDeleteFromAllProfiles() {
        return this.deleteFromAllProfiles;
    }

    @Nullable
    public List<String> getPathExpressions() {
        return this.pathExpressions;
    }

    @NonNull
    public String toString() {
        return "DeleteQuarkusProperty(propertyKey=" + this.getPropertyKey() + ", oldValue=" + this.getOldValue() + ", profile=" + this.getProfile() + ", deleteFromAllProfiles=" + this.getDeleteFromAllProfiles() + ", pathExpressions=" + this.getPathExpressions() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteQuarkusProperty)) {
            return false;
        }
        DeleteQuarkusProperty other = (DeleteQuarkusProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$deleteFromAllProfiles = this.getDeleteFromAllProfiles();
        Boolean other$deleteFromAllProfiles = other.getDeleteFromAllProfiles();
        if (this$deleteFromAllProfiles == null ? other$deleteFromAllProfiles != null : !((Object)this$deleteFromAllProfiles).equals(other$deleteFromAllProfiles)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        List<String> this$pathExpressions = this.getPathExpressions();
        List<String> other$pathExpressions = other.getPathExpressions();
        return !(this$pathExpressions == null ? other$pathExpressions != null : !((Object)this$pathExpressions).equals(other$pathExpressions));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteQuarkusProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleteFromAllProfiles = this.getDeleteFromAllProfiles();
        result = result * 59 + ($deleteFromAllProfiles == null ? 43 : ((Object)$deleteFromAllProfiles).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        List<String> $pathExpressions = this.getPathExpressions();
        result = result * 59 + ($pathExpressions == null ? 43 : ((Object)$pathExpressions).hashCode());
        return result;
    }
}

