/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.AddProperty;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.quarkus.QuarkusExecutionContextView;
import org.openrewrite.quarkus.QuarkusProfileUtils;
import org.openrewrite.quarkus.search.FindQuarkusProperties;
import org.openrewrite.yaml.DeleteProperty;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.tree.Yaml;

public class DeleteQuarkusPropertyVisitor
extends TreeVisitor<Tree, ExecutionContext> {
    final String propertyKey;
    @Nullable
    final String oldValue;
    @Nullable
    final String profile;
    @Nullable
    final Boolean searchAllProfiles;
    @Nullable
    final List<String> pathExpressions;

    public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
        QuarkusExecutionContextView quarkusCtx = QuarkusExecutionContextView.view(ctx);
        return quarkusCtx.isQuarkusConfigFile((Tree)sourceFile, this.pathExpressions);
    }

    @Nullable
    public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
        if (tree instanceof Properties.File) {
            return this.visitPropertiesFile(tree, ctx);
        }
        if (tree instanceof Yaml.Documents) {
            return this.visitYamlDocuments(tree, ctx);
        }
        return tree;
    }

    @Nullable
    private Tree visitPropertiesFile(Tree tree, ExecutionContext ctx) {
        Set<Properties.Entry> existingProperties = FindQuarkusProperties.find((Properties)tree, this.propertyKey, this.profile, this.searchAllProfiles);
        for (Properties.Entry entry : existingProperties) {
            if (this.oldValue != null && !this.oldValue.equals(entry.getValue().getText())) continue;
            String[] profiles = QuarkusProfileUtils.getProfilesFromPropertyKey(entry.getKey());
            if (profiles.length == 0 || !Boolean.FALSE.equals(this.searchAllProfiles)) {
                tree = new org.openrewrite.properties.DeleteProperty(entry.getKey(), Boolean.valueOf(false)).getVisitor().visit(tree, (Object)ctx);
                continue;
            }
            tree = new org.openrewrite.properties.DeleteProperty(entry.getKey(), Boolean.valueOf(false)).getVisitor().visit(tree, (Object)ctx);
            ArrayList<String> remainingProfiles = new ArrayList<String>(existingProperties.size());
            for (String profile : profiles) {
                if (profile.equals(this.profile)) continue;
                remainingProfiles.add(profile);
            }
            if (remainingProfiles.isEmpty()) continue;
            String keyWithoutProfile = QuarkusProfileUtils.getKeyWithoutProfile(entry.getKey());
            String key = "%" + String.join((CharSequence)",", remainingProfiles) + "." + keyWithoutProfile;
            String value = entry.getValue().getText();
            tree = new AddProperty(key, value, null, null).getVisitor().visit(tree, (Object)ctx);
        }
        return tree;
    }

    @Nullable
    private Tree visitYamlDocuments(Tree tree, ExecutionContext ctx) {
        Set<Yaml.Mapping.Entry> existingProperties = FindQuarkusProperties.find((Yaml.Documents)tree, this.propertyKey, this.profile, this.searchAllProfiles);
        for (Yaml.Mapping.Entry entry : existingProperties) {
            String originalEntryValue = ((Yaml.Scalar)entry.getValue()).getValue();
            if (this.oldValue != null && !this.oldValue.equals(originalEntryValue)) continue;
            String key = entry.getKey().getValue();
            String[] profiles = QuarkusProfileUtils.getProfilesFromPropertyKey(key);
            if (profiles.length == 0 || !Boolean.FALSE.equals(this.searchAllProfiles)) {
                tree = new DeleteProperty(key, Boolean.valueOf(false), null, null).getVisitor().visit(tree, (Object)ctx);
                continue;
            }
            tree = new DeleteProperty(key, Boolean.valueOf(false), Boolean.valueOf(false), null).getVisitor().visit(tree, (Object)ctx);
            ArrayList<String> remainingProfiles = new ArrayList<String>();
            for (String profile : profiles) {
                if (profile.equals(this.profile)) continue;
                remainingProfiles.add(profile);
            }
            if (remainingProfiles.isEmpty()) continue;
            StringBuilder newProperties = new StringBuilder();
            String keyWithoutProfile = QuarkusProfileUtils.getKeyWithoutProfile(key);
            QuarkusProfileUtils.formatKey(newProperties, keyWithoutProfile, originalEntryValue, remainingProfiles);
            tree = new MergeYaml("$", newProperties.toString(), Boolean.valueOf(false), null, null).getVisitor().visit(tree, (Object)ctx);
        }
        return tree;
    }

    @ConstructorProperties(value={"propertyKey", "oldValue", "profile", "searchAllProfiles", "pathExpressions"})
    @Generated
    public DeleteQuarkusPropertyVisitor(String propertyKey, @Nullable String oldValue, @Nullable String profile, @Nullable Boolean searchAllProfiles, @Nullable List<String> pathExpressions) {
        this.propertyKey = propertyKey;
        this.oldValue = oldValue;
        this.profile = profile;
        this.searchAllProfiles = searchAllProfiles;
        this.pathExpressions = pathExpressions;
    }
}

