/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.reactive.reactor;

import java.time.Duration;
import java.util.Queue;
import java.util.function.Consumer;
import org.openrewrite.java.template.RecipeDescriptor;
import reactor.core.Disposable;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.ReplayProcessor;
import reactor.core.publisher.Sinks;
import reactor.core.publisher.UnicastProcessor;
import reactor.core.scheduler.Scheduler;
import reactor.util.concurrent.Queues;

@RecipeDescriptor(name="Replace various `Processor.create` calls with their `Sinks` equivalent", description="As of 3.5 Processors are deprecated and Sinks are preferred.")
public class ReactorProcessorCreateToSink {

    @RecipeDescriptor(name="Replace `UnicastProcessor.create(Queue, Consumer, Disposable)` with `Sinks.many().unicast().onBackpressureBuffer(Queue, Disposable)`", description="As of 3.5 UnicastProcessor is deprecated and Sinks are preferred")
    public static class UnicastProcessorCreateQueueConsumerDisposableToSink {
        void createBefore(Queue queue, Consumer cons, Disposable disp) {
            UnicastProcessor.create((Queue)queue, (Consumer)cons, (Disposable)disp);
        }

        void sinkAfter(Queue queue, Consumer cons, Disposable disp) {
            Sinks.many().unicast().onBackpressureBuffer(queue, disp);
        }
    }

    @RecipeDescriptor(name="Replace `UnicastProcessor.create(Queue, Disposable)` with `Sinks.many().unicast().onBackpressureBuffer(Queue, Disposable)`", description="As of 3.5 UnicastProcessor is deprecated and Sinks are preferred")
    public static class UnicastProcessorCreateQueueDisposableToSink {
        void createBefore(Queue queue, Disposable disp) {
            UnicastProcessor.create((Queue)queue, (Disposable)disp);
        }

        void sinkAfter(Queue queue, Disposable disp) {
            Sinks.many().unicast().onBackpressureBuffer(queue, disp);
        }
    }

    @RecipeDescriptor(name="Replace `UnicastProcessor.create(Queue)` with `Sinks.many().unicast().onBackpressureBuffer(Queue)`", description="As of 3.5 UnicastProcessor is deprecated and Sinks are preferred")
    public static class UnicastProcessorCreateQueueToSink {
        void createBefore(Queue queue) {
            UnicastProcessor.create((Queue)queue);
        }

        void sinkAfter(Queue queue) {
            Sinks.many().unicast().onBackpressureBuffer(queue);
        }
    }

    @RecipeDescriptor(name="Replace `UnicastProcessor.create()` with `Sinks.many().unicast().onBackpressureBuffer()`", description="As of 3.5 UnicastProcessor is deprecated and Sinks are preferred")
    public static class UnicastProcessorCreateToSink {
        void createBefore() {
            UnicastProcessor.create();
        }

        void sinkAfter() {
            Sinks.many().unicast().onBackpressureBuffer();
        }
    }

    @RecipeDescriptor(name="Replace `EmitterProcessor.create(int, Boolean)` with `Sinks.many().multicast().onBackpressureBuffer(int, Boolean)`", description="As of 3.5 EmitterProcessor is deprecated and Sinks are preferred")
    public static class EmitterProcessorCreateIntBooleanToSink {
        void createBefore(Integer integer, Boolean bool) {
            EmitterProcessor.create((int)integer, (boolean)bool);
        }

        void sinkAfter(Integer integer, Boolean bool) {
            Sinks.many().multicast().onBackpressureBuffer(integer.intValue(), bool.booleanValue());
        }
    }

    @RecipeDescriptor(name="Replace `EmitterProcessor.create(int)` with `Sinks.many().multicast().onBackpressureBuffer(int)`", description="As of 3.5 EmitterProcessor is deprecated and Sinks are preferred")
    public static class EmitterProcessorCreateIntToSink {
        void createBefore(Integer integer) {
            EmitterProcessor.create((int)integer);
        }

        void sinkAfter(Integer integer) {
            Sinks.many().multicast().onBackpressureBuffer(integer.intValue());
        }
    }

    @RecipeDescriptor(name="Replace `EmitterProcessor.create(Boolean)` with `Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, Boolean)`", description="As of 3.5 EmitterProcessor is deprecated and Sinks are preferred")
    public static class EmitterProcessorCreateBooleanToSink {
        void createBefore(Boolean bool) {
            EmitterProcessor.create((boolean)bool);
        }

        void sinkAfter(Boolean bool) {
            Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, bool.booleanValue());
        }
    }

    @RecipeDescriptor(name="Replace `EmitterProcessor.create()` with `Sinks.many().multicast().onBackpressureBuffer()`", description="As of 3.5 EmitterProcessor is deprecated and Sinks are preferred")
    public static class EmitterProcessorCreateToSink {
        void createBefore() {
            EmitterProcessor.create();
        }

        void sinkAfter() {
            Sinks.many().multicast().onBackpressureBuffer();
        }
    }

    @RecipeDescriptor(name="Replace `DirectProcessor.create()` with `Sinks.many().multicast().directBestEffort()`", description="As of 3.5 DirectProcessor is deprecated and Sinks are preferred")
    public static class DirectProcessorCreateToSink {
        void createBefore() {
            DirectProcessor.create();
        }

        void sinkAfter() {
            Sinks.many().multicast().directBestEffort();
        }
    }

    @RecipeDescriptor(name="Replace `ReplayProcessor.createTimeout(Duration, Scheduler)` with `Sinks.many().replay().limit(Duration, Scheduler)`", description="As of 3.5 ReplayProcessor is deprecated and Sinks are preferred")
    public static class ReplayProcessorCreateTimeoutSchedulerToSink {
        void createBefore(Duration duration, Scheduler scheduler) {
            ReplayProcessor.createTimeout((Duration)duration, (Scheduler)scheduler);
        }

        void sinkAfter(Duration duration, Scheduler scheduler) {
            Sinks.many().replay().limit(duration, scheduler);
        }
    }

    @RecipeDescriptor(name="Replace `ReplayProcessor.createTimeout(Duration)` with `Sinks.many().replay().limit(duration)`", description="As of 3.5 ReplayProcessor is deprecated and Sinks are preferred")
    public static class ReplayProcessorCreateTimeoutToSink {
        void createBefore(Duration duration) {
            ReplayProcessor.createTimeout((Duration)duration);
        }

        void sinkAfter(Duration duration) {
            Sinks.many().replay().limit(duration);
        }
    }

    @RecipeDescriptor(name="Replace `ReplayProcessor.createSizeAndTimeout(int, Duration, Scheduler)` with `Sinks.many().replay().limit(int, Duration, Scheduler)`", description="As of 3.5 ReplayProcessor is deprecated and Sinks are preferred")
    public static class ReplayProcessorCreateSizeAndTimeoutSchedulerToSink {
        void createBefore(Integer integer, Duration duration, Scheduler scheduler) {
            ReplayProcessor.createSizeAndTimeout((int)integer, (Duration)duration, (Scheduler)scheduler);
        }

        void sinkAfter(Integer integer, Duration duration, Scheduler scheduler) {
            Sinks.many().replay().limit(integer.intValue(), duration, scheduler);
        }
    }

    @RecipeDescriptor(name="Replace `ReplayProcessor.createSizeAndTimeout(int, Duration)` with `Sinks.many().replay().limit(int, duration)`", description="As of 3.5 ReplayProcessor is deprecated and Sinks are preferred")
    public static class ReplayProcessorCreateSizeAndTimeoutToSink {
        void createBefore(Integer integer, Duration duration) {
            ReplayProcessor.createSizeAndTimeout((int)integer, (Duration)duration);
        }

        void sinkAfter(Integer integer, Duration duration) {
            Sinks.many().replay().limit(integer.intValue(), duration);
        }
    }

    @RecipeDescriptor(name="Replace `ReplayProcessor.create(int, true)` with `Sinks.many().replay().all(int)`", description="As of 3.5 ReplayProcessor is deprecated and Sinks are preferred")
    public static class ReplayProcessorCreateIntLiteralTrueToSink {
        void createBefore(Integer integer) {
            ReplayProcessor.create((int)integer, (boolean)true);
        }

        void sinkAfter(Integer integer) {
            Sinks.many().replay().all(integer.intValue());
        }
    }

    @RecipeDescriptor(name="Replace `ReplayProcessor.create(int, false)` with `Sinks.many().replay().limit(int)`", description="As of 3.5 ReplayProcessor is deprecated and Sinks are preferred")
    public static class ReplayProcessorCreateIntLiteralFalseToSink {
        void createBefore(Integer integer) {
            ReplayProcessor.create((int)integer, (boolean)false);
        }

        void sinkAfter(Integer integer) {
            Sinks.many().replay().limit(integer.intValue());
        }
    }

    @RecipeDescriptor(name="Replace `ReplayProcessor.create(int)` with `Sinks.many().replay().limit(int)`", description="As of 3.5 ReplayProcessor is deprecated and Sinks are preferred")
    public static class ReplayProcessorCreateIntToSink {
        void createBefore(Integer integer) {
            ReplayProcessor.create((int)integer);
        }

        void sinkAfter(Integer integer) {
            Sinks.many().replay().limit(integer.intValue());
        }
    }

    @RecipeDescriptor(name="Replace `ReplayProcessor.create()` with `Sinks.many().replay().all()`", description="As of 3.5 ReplayProcessor is deprecated and Sinks are preferred")
    public static class ReplayProcessorCreateToSink {
        void createBefore() {
            ReplayProcessor.create();
        }

        void sinkAfter() {
            Sinks.many().replay().all();
        }
    }

    @RecipeDescriptor(name="Replace `MonoProcessor.create()` with `Sinks.one()`", description="As of 3.5 MonoProcessor is deprecated and Sinks are preferred")
    public static class MonoProcessorCreateToSink {
        void createBefore() {
            MonoProcessor.create();
        }

        void sinkAfter() {
            Sinks.one();
        }
    }
}

