/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.table.RewriteRecipeSource;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.FindProperty;
import org.openrewrite.yaml.tree.Yaml;

public class FindRecipes
extends Recipe {
    RewriteRecipeSource recipeSource = new RewriteRecipeSource((Recipe)this);

    public String getDisplayName() {
        return "Find OpenRewrite recipes";
    }

    public String getDescription() {
        return "This recipe finds all OpenRewrite recipes, primarily to produce a data table that is being used to experiment with fine-tuning a large language model to produce more recipes.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TreeVisitor<?, ExecutionContext> findImperativeRecipes = this.findImperativeRecipes();
        final TreeVisitor<?, ExecutionContext> findRefasterRecipes = this.findRefasterRecipes();
        final TreeVisitor<?, ExecutionContext> findYamlRecipes = this.findYamlRecipes();
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree preVisit(@NonNull Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                tree = findImperativeRecipes.visit(tree, (Object)ctx);
                tree = findRefasterRecipes.visit(tree, (Object)ctx);
                return findYamlRecipes.visit(tree, (Object)ctx);
            }
        };
    }

    private TreeVisitor<?, ExecutionContext> findRefasterRecipes() {
        String recipeDescriptor = "org.openrewrite.java.template.RecipeDescriptor";
        final AnnotationMatcher annotationMatcher = new AnnotationMatcher("@" + recipeDescriptor);
        return Preconditions.check((TreeVisitor)new UsesType(recipeDescriptor, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                for (J.Annotation annotation : cd.getLeadingAnnotations()) {
                    if (!annotationMatcher.matches(annotation)) continue;
                    String name = null;
                    String description = null;
                    for (Expression argument : annotation.getArguments()) {
                        J.Assignment assignment;
                        if (!(argument instanceof J.Assignment) || !((assignment = (J.Assignment)argument).getVariable() instanceof J.Identifier)) continue;
                        String simpleName = ((J.Identifier)assignment.getVariable()).getSimpleName();
                        if ("name".equals(simpleName)) {
                            if (!(assignment.getAssignment() instanceof J.Literal)) continue;
                            name = (String)((J.Literal)assignment.getAssignment()).getValue();
                            continue;
                        }
                        if (!"description".equals(simpleName) || !(assignment.getAssignment() instanceof J.Literal)) continue;
                        description = (String)((J.Literal)assignment.getAssignment()).getValue();
                    }
                    if (name == null || description == null) continue;
                    FindRecipes.this.recipeSource.insertRow(ctx, (Object)new RewriteRecipeSource.Row(name, description, RewriteRecipeSource.RecipeType.Refaster, cd.printTrimmed(this.getCursor()), "[]"));
                    return (J.ClassDeclaration)SearchResult.found((Tree)cd);
                }
                return cd;
            }
        });
    }

    private TreeVisitor<?, ExecutionContext> findImperativeRecipes() {
        final MethodMatcher getDisplayName = new MethodMatcher("org.openrewrite.Recipe getDisplayName()", true);
        final MethodMatcher getDescription = new MethodMatcher("org.openrewrite.Recipe getDescription()", true);
        final AnnotationMatcher optionAnnotation = new AnnotationMatcher("@org.openrewrite.Option");
        return Preconditions.check((TreeVisitor)new UsesType("org.openrewrite.Recipe", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final List<J.VariableDeclarations> options = new ArrayList<J.VariableDeclarations>();

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (TypeUtils.isAssignableTo((String)"org.openrewrite.Recipe", (JavaType)classDecl.getType())) {
                    FindRecipes.this.recipeSource.insertRow(ctx, (Object)new RewriteRecipeSource.Row((String)this.getCursor().getMessage("displayName"), (String)this.getCursor().getMessage("description"), RewriteRecipeSource.RecipeType.Java, ((J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class)).printAllTrimmed(), this.convertOptionsToJSON(this.options)));
                    return classDecl.withName((J.Identifier)SearchResult.found((Tree)classDecl.getName()));
                }
                return cd;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (multiVariable.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)optionAnnotation).matches(arg_0))) {
                    this.options.add(multiVariable);
                }
                return super.visitVariableDeclarations(multiVariable, (Object)ctx);
            }

            public J.Return visitReturn(J.Return aReturn, ExecutionContext ctx) {
                J j = (J)this.getCursor().dropParentUntil(it -> it instanceof J.MethodDeclaration || it instanceof J.ClassDeclaration).getValue();
                if (j instanceof J.MethodDeclaration) {
                    J.MethodDeclaration method = (J.MethodDeclaration)j;
                    if (getDisplayName.matches(method.getMethodType()) && aReturn.getExpression() instanceof J.Literal) {
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, "displayName", Objects.requireNonNull(((J.Literal)aReturn.getExpression()).getValue()));
                    }
                    if (getDescription.matches(method.getMethodType()) && aReturn.getExpression() instanceof J.Literal) {
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, "description", Objects.requireNonNull(((J.Literal)aReturn.getExpression()).getValue()));
                    }
                }
                return super.visitReturn(aReturn, (Object)ctx);
            }

            private String convertOptionsToJSON(List<J.VariableDeclarations> options) {
                ArrayNode optionsArray = JsonNodeFactory.instance.arrayNode();
                for (J.VariableDeclarations option : options) {
                    ObjectNode optionNode = optionsArray.addObject();
                    optionNode.put("name", ((J.VariableDeclarations.NamedVariable)option.getVariables().get(0)).getSimpleName());
                    this.mapOptionAnnotation(option.getLeadingAnnotations(), optionNode);
                }
                return optionsArray.toString();
            }

            private void mapOptionAnnotation(List<J.Annotation> leadingAnnotations, ObjectNode optionNode) {
                for (J.Annotation annotation : leadingAnnotations) {
                    if (!optionAnnotation.matches(annotation) || annotation.getArguments() == null) continue;
                    for (Expression argument : annotation.getArguments()) {
                        J.NewArray newArray;
                        J.Assignment assignment;
                        if (!(argument instanceof J.Assignment) || !((assignment = (J.Assignment)argument).getVariable() instanceof J.Identifier)) continue;
                        J.Identifier identifier = (J.Identifier)assignment.getVariable();
                        if (assignment.getAssignment() instanceof J.Literal) {
                            optionNode.set(identifier.getSimpleName(), (JsonNode)this.mapValue(((J.Literal)assignment.getAssignment()).getValue()));
                            continue;
                        }
                        if (!(assignment.getAssignment() instanceof J.NewArray) || (newArray = (J.NewArray)assignment.getAssignment()).getInitializer() == null) continue;
                        ArrayNode valuesArray = optionNode.putArray(identifier.getSimpleName());
                        for (Expression expression : newArray.getInitializer()) {
                            if (!(expression instanceof J.Literal)) continue;
                            valuesArray.add((JsonNode)this.mapValue(((J.Literal)expression).getValue()));
                        }
                    }
                }
            }

            private ValueNode mapValue(@Nullable Object value) {
                if (value instanceof String) {
                    return JsonNodeFactory.instance.textNode((String)value);
                }
                if (value instanceof Boolean) {
                    return JsonNodeFactory.instance.booleanNode(((Boolean)value).booleanValue());
                }
                if (value instanceof Integer) {
                    return JsonNodeFactory.instance.numberNode((Integer)value);
                }
                if (value == null) {
                    return JsonNodeFactory.instance.nullNode();
                }
                throw new IllegalArgumentException(String.valueOf(value));
            }
        });
    }

    private TreeVisitor<?, ExecutionContext> findYamlRecipes() {
        return Preconditions.check((Recipe)new FindProperty("type", Boolean.valueOf(false), "specs.openrewrite.org/v1beta/recipe"), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                Yaml.Document doc = super.visitDocument(document, (Object)ctx);
                if ("specs.openrewrite.org/v1beta/recipe".equals(this.extractValue((Yaml)doc, "type"))) {
                    String displayName = this.extractValue((Yaml)doc, "displayName");
                    String description = this.extractValue((Yaml)doc, "description");
                    if (displayName != null && description != null) {
                        FindRecipes.this.recipeSource.insertRow(ctx, (Object)new RewriteRecipeSource.Row(displayName, description, RewriteRecipeSource.RecipeType.Yaml, doc.withPrefix("").printTrimmed(this.getCursor()), "[]"));
                        return (Yaml.Document)SearchResult.found((Tree)doc);
                    }
                }
                return doc;
            }

            private @Nullable String extractValue(Yaml yaml, String key) {
                Yaml.Block first;
                Set blocks = FindProperty.find((Yaml)yaml, (String)key, (Boolean)false);
                if (!blocks.isEmpty() && (first = (Yaml.Block)blocks.iterator().next()) instanceof Yaml.Scalar) {
                    return ((Yaml.Scalar)first).getValue();
                }
                return null;
            }
        });
    }
}

