/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class SingleDocumentExample
extends Recipe {
    private static final String DOCUMENT_EXAMPLE = "org.openrewrite.DocumentExample";
    private static final AnnotationMatcher DOCUMENT_EXAMPLE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.openrewrite.DocumentExample");

    public String getDisplayName() {
        return "Single `@DocumentExample` per test class";
    }

    public String getDescription() {
        return "Ensures that there is only one `@DocumentExample` annotation per test class, as that looks best in the documentation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(DOCUMENT_EXAMPLE, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                AtomicBoolean foundDocumentExample = new AtomicBoolean(false);
                return cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), st -> {
                    if (!(st instanceof J.MethodDeclaration) || FindAnnotations.find((J)st, (String)SingleDocumentExample.DOCUMENT_EXAMPLE).isEmpty()) {
                        return st;
                    }
                    if (!foundDocumentExample.get()) {
                        foundDocumentExample.set(true);
                        return st;
                    }
                    return new RemoveAnnotationVisitor(DOCUMENT_EXAMPLE_ANNOTATION_MATCHER).visitMethodDeclaration((J.MethodDeclaration)st, ctx);
                })));
            }
        });
    }
}

