/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes.migrate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class RemoveTraitsUsageRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace static `Traits` methods with constructor calls";
    }

    public String getDescription() {
        return "Replace the usage of static `Traits` methods with the corresponding constructor calls, as the `Traits` classes were an early abstraction with undesirable import conflicts.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new LiteralRecipe(), new VariableAccessRecipe(), new MethodMatcherRecipe(), new StringSignatureRecipe(), new AnnotationMatcherRecipe(), new ClassTypeRecipe(), new DependencyRecipe(), new PluginRecipe(), new JvmTestSuiteRecipe()});
    }

    @NullMarked
    public static class LiteralRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Remove `org.openrewrite.java.trait.Traits.literal()` usage";
        }

        public String getDescription() {
            return "Removes the usage of static `org.openrewrite.java.trait.Traits.literal()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.openrewrite.java.trait.Traits.literal()").bindType("org.openrewrite.java.trait.Literal.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.openrewrite.java.trait.Traits");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new org.openrewrite.java.trait.Literal.Matcher()").bindType("org.openrewrite.java.trait.Literal.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.java.trait.Literal", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.Literal.Matcher", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.Traits", Boolean.valueOf(true)), new UsesMethod("org.openrewrite.java.trait.Traits literal(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class VariableAccessRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Remove `org.openrewrite.java.trait.Traits.variableAccess()` usage";
        }

        public String getDescription() {
            return "Removes the usage of static `org.openrewrite.java.trait.Traits.variableAccess()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.openrewrite.java.trait.Traits.variableAccess()").bindType("org.openrewrite.java.trait.VariableAccess.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.openrewrite.java.trait.Traits");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new org.openrewrite.java.trait.VariableAccess.Matcher()").bindType("org.openrewrite.java.trait.VariableAccess.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.java.trait.Traits", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.VariableAccess", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.VariableAccess.Matcher", Boolean.valueOf(true)), new UsesMethod("org.openrewrite.java.trait.Traits variableAccess(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MethodMatcherRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Remove `org.openrewrite.java.trait.Traits.methodAccess(MethodMatcher)` usage";
        }

        public String getDescription() {
            return "Removes the usage of static `org.openrewrite.java.trait.Traits.methodAccess(MethodMatcher)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.openrewrite.java.trait.Traits.methodAccess(#{matcher:any(org.openrewrite.java.MethodMatcher)})").bindType("org.openrewrite.java.trait.MethodAccess.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.openrewrite.java.trait.Traits");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new org.openrewrite.java.trait.MethodAccess.Matcher(#{matcher:any(org.openrewrite.java.MethodMatcher)})").bindType("org.openrewrite.java.trait.MethodAccess.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.java.MethodMatcher", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.MethodAccess", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.MethodAccess.Matcher", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.Traits", Boolean.valueOf(true)), new UsesMethod("org.openrewrite.java.trait.Traits methodAccess(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringSignatureRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Remove `org.openrewrite.java.trait.Traits.annotated(String)` usage";
        }

        public String getDescription() {
            return "Removes the usage of static `org.openrewrite.java.trait.Traits.annotated(String)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.openrewrite.java.trait.Traits.annotated(#{signature:any(java.lang.String)})").bindType("org.openrewrite.java.trait.Annotated.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.openrewrite.java.trait.Traits");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new org.openrewrite.java.trait.Annotated.Matcher(#{signature:any(java.lang.String)})").bindType("org.openrewrite.java.trait.Annotated.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.java.trait.Annotated", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.Annotated.Matcher", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.Traits", Boolean.valueOf(true)), new UsesMethod("org.openrewrite.java.trait.Traits annotated(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AnnotationMatcherRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Remove `org.openrewrite.java.trait.Traits.annotated(AnnotationMatcher)` usage";
        }

        public String getDescription() {
            return "Removes the usage of static `org.openrewrite.java.trait.Traits.annotated(AnnotationMatcher)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.openrewrite.java.trait.Traits.annotated(#{matcher:any(org.openrewrite.java.AnnotationMatcher)})").bindType("org.openrewrite.java.trait.Annotated.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.openrewrite.java.trait.Traits");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new org.openrewrite.java.trait.Annotated.Matcher(#{matcher:any(org.openrewrite.java.AnnotationMatcher)})").bindType("org.openrewrite.java.trait.Annotated.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.java.AnnotationMatcher", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.Annotated", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.Annotated.Matcher", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.Traits", Boolean.valueOf(true)), new UsesMethod("org.openrewrite.java.trait.Traits annotated(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ClassTypeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Remove `org.openrewrite.java.trait.Traits.annotated(Class<?>)` usage";
        }

        public String getDescription() {
            return "Removes the usage of static `org.openrewrite.java.trait.Traits.annotated(Class<?>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.openrewrite.java.trait.Traits.annotated(#{annotationType:any(java.lang.Class<?>)})").bindType("org.openrewrite.java.trait.Annotated.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.openrewrite.java.trait.Traits");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new org.openrewrite.java.trait.Annotated.Matcher(#{annotationType:any(java.lang.Class<?>)})").bindType("org.openrewrite.java.trait.Annotated.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.java.trait.Annotated", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.Annotated.Matcher", Boolean.valueOf(true)), new UsesType("org.openrewrite.java.trait.Traits", Boolean.valueOf(true)), new UsesMethod("org.openrewrite.java.trait.Traits annotated(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DependencyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Remove `org.openrewrite.gradle.trait.Traits.gradleDependency()` usage";
        }

        public String getDescription() {
            return "Removes the usage of static `org.openrewrite.gradle.trait.Traits.gradleDependency()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.openrewrite.gradle.trait.Traits.gradleDependency()").bindType("org.openrewrite.gradle.trait.GradleDependency.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.openrewrite.gradle.trait.Traits");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new org.openrewrite.gradle.trait.GradleDependency.Matcher()").bindType("org.openrewrite.gradle.trait.GradleDependency.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.gradle.trait.GradleDependency", Boolean.valueOf(true)), new UsesType("org.openrewrite.gradle.trait.GradleDependency.Matcher", Boolean.valueOf(true)), new UsesType("org.openrewrite.gradle.trait.Traits", Boolean.valueOf(true)), new UsesMethod("org.openrewrite.gradle.trait.Traits gradleDependency(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PluginRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Remove `org.openrewrite.maven.trait.Traits.mavenPlugin()` usage";
        }

        public String getDescription() {
            return "Removes the usage of static `org.openrewrite.maven.trait.Traits.mavenPlugin()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.openrewrite.maven.trait.Traits.mavenPlugin()").bindType("org.openrewrite.maven.trait.MavenPlugin.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.openrewrite.maven.trait.Traits");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new org.openrewrite.maven.trait.MavenPlugin.Matcher()").bindType("org.openrewrite.maven.trait.MavenPlugin.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.maven.trait.MavenPlugin", Boolean.valueOf(true)), new UsesType("org.openrewrite.maven.trait.MavenPlugin.Matcher", Boolean.valueOf(true)), new UsesType("org.openrewrite.maven.trait.Traits", Boolean.valueOf(true)), new UsesMethod("org.openrewrite.maven.trait.Traits mavenPlugin(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JvmTestSuiteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Remove `org.openrewrite.gradle.trait.Traits.jvmTestSuite()` usage";
        }

        public String getDescription() {
            return "Removes the usage of static `org.openrewrite.gradle.trait.Traits.jvmTestSuite()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.openrewrite.gradle.trait.Traits.jvmTestSuite()").bindType("org.openrewrite.gradle.trait.JvmTestSuite.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.openrewrite.gradle.trait.Traits");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new org.openrewrite.gradle.trait.JvmTestSuite.Matcher()").bindType("org.openrewrite.gradle.trait.JvmTestSuite.Matcher").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.gradle.trait.JvmTestSuite", Boolean.valueOf(true)), new UsesType("org.openrewrite.gradle.trait.JvmTestSuite.Matcher", Boolean.valueOf(true)), new UsesType("org.openrewrite.gradle.trait.Traits", Boolean.valueOf(true)), new UsesMethod("org.openrewrite.gradle.trait.Traits jvmTestSuite(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

