/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rewrite;

import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.trait.Trait;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class Recipe
implements Trait<Tree> {
    private static final MethodMatcher getDisplayName = new MethodMatcher("org.openrewrite.Recipe getDisplayName()", true);
    private static final MethodMatcher getDescription = new MethodMatcher("org.openrewrite.Recipe getDescription()", true);
    private Cursor cursor;

    public Recipe(Cursor cursor) {
        this.cursor = cursor;
    }

    public String getDisplayName() {
        if (this.getTree() instanceof J.ClassDeclaration) {
            return this.getLiteralReturnValue(getDisplayName);
        }
        return this.getYamlMappingValue("displayName");
    }

    public Recipe withDisplayName(String displayName) {
        if (this.getTree() instanceof J.ClassDeclaration) {
            return this.withLiteralReturnValue(getDisplayName, displayName);
        }
        return this.withYamlMappingValue("displayName", displayName);
    }

    public String getDescription() {
        if (this.getTree() instanceof J.ClassDeclaration) {
            return this.getLiteralReturnValue(getDescription);
        }
        return this.getYamlMappingValue("description");
    }

    public Recipe withDescription(String description) {
        if (this.getTree() instanceof J.ClassDeclaration) {
            return this.withLiteralReturnValue(getDescription, description);
        }
        return this.withYamlMappingValue("description", description);
    }

    private String getYamlMappingValue(final String key) {
        final AtomicReference value = new AtomicReference();
        new YamlVisitor<Integer>(){

            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, Integer p) {
                if (new JsonPathMatcher("$." + key).matches(this.getCursor()) && entry.getValue() instanceof Yaml.Scalar) {
                    value.set(((Yaml.Scalar)entry.getValue()).getValue());
                }
                return entry;
            }
        }.visit(this.getTree(), (Object)0, this.cursor.getParentOrThrow());
        return (String)value.get();
    }

    private String getLiteralReturnValue(final MethodMatcher method) {
        StringBuilder retValue = new StringBuilder();
        final J.ClassDeclaration cd = (J.ClassDeclaration)this.getTree();
        new JavaIsoVisitor<StringBuilder>(){

            public J.Return visitReturn(J.Return aReturn, StringBuilder ret) {
                J.MethodDeclaration md = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                if (md != null && method.matches(md, cd) && aReturn.getExpression() instanceof J.Literal) {
                    ret.append(((J.Literal)aReturn.getExpression()).getValue());
                }
                return aReturn;
            }
        }.visit((Tree)cd, (Object)retValue, this.getCursor().getParentOrThrow());
        return retValue.toString();
    }

    private Recipe withLiteralReturnValue(final MethodMatcher method, final String value) {
        final J.ClassDeclaration cd = (J.ClassDeclaration)this.getTree();
        this.cursor = new Cursor(this.cursor.getParent(), (Object)new JavaIsoVisitor<Integer>(){

            public J.Return visitReturn(J.Return aReturn, Integer p) {
                J.Literal exp;
                J.MethodDeclaration md = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                if (md != null && method.matches(md, cd) && aReturn.getExpression() instanceof J.Literal && !value.equals((exp = (J.Literal)aReturn.getExpression()).getValue())) {
                    return aReturn.withExpression((Expression)exp.withValue((Object)value).withValueSource("\"" + value + "\""));
                }
                return aReturn;
            }
        }.visitNonNull((Tree)cd, (Object)0, this.getCursor().getParentOrThrow()));
        return this;
    }

    private Recipe withYamlMappingValue(final String key, final String value) {
        this.cursor = new Cursor(this.cursor.getParent(), (Object)new YamlVisitor<Integer>(){

            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, Integer p) {
                if (new JsonPathMatcher("$." + key).matches(this.getCursor()) && entry.getValue() instanceof Yaml.Scalar) {
                    return entry.withValue((Yaml.Block)((Yaml.Scalar)entry.getValue()).withValue(value));
                }
                return entry;
            }
        }.visitNonNull(this.getTree(), (Object)0, this.cursor.getParentOrThrow()));
        return this;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    public static class Matcher
    extends SimpleTraitMatcher<Recipe> {
        protected @Nullable Recipe test(final Cursor cursor) {
            Object value = cursor.getValue();
            if (value instanceof J.ClassDeclaration) {
                J.ClassDeclaration classDecl = (J.ClassDeclaration)value;
                if (TypeUtils.isAssignableTo((String)"org.openrewrite.Recipe", (JavaType)classDecl.getType())) {
                    return new Recipe(cursor);
                }
            } else if (value instanceof Yaml.Document) {
                final AtomicReference recipe = new AtomicReference();
                new YamlVisitor<Integer>(){

                    public Yaml visitScalar(Yaml.Scalar scalar, Integer p) {
                        if (new JsonPathMatcher("$.type").matches(this.getCursor().getParentOrThrow()) && "specs.openrewrite.org/v1beta/recipe".equals(scalar.getValue())) {
                            recipe.set(new Recipe(cursor));
                        }
                        return scalar;
                    }
                }.visit((Tree)((Yaml.Document)value), (Object)0, cursor.getParentOrThrow());
                return (Recipe)recipe.get();
            }
            return null;
        }
    }
}

