/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceNullWithDoesNotExist
extends Recipe {
    private static final MethodMatcher ASSERTIONS_MATCHER = new MethodMatcher("org.openrewrite.*.Assertions *(String, String, ..)");

    public String getDisplayName() {
        return "Replace null with RewriteTest.doesNotExist()";
    }

    public String getDescription() {
        return "Replace the first or second `null` argument in OpenRewrite Assertions class methods with `RewriteTest.doesNotExist()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERTIONS_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERTIONS_MATCHER.matches((MethodCall)mi)) {
                    return mi.withArguments(ListUtils.map((List)method.getArguments(), (index, arg) -> {
                        if (J.Literal.isLiteralValue((Expression)arg, null) && (index == 0 || index == 1)) {
                            J.MethodInvocation doesNotExist = (J.MethodInvocation)JavaTemplate.builder((String)"doesNotExist()").contextSensitive().javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{"package org.openrewrite.test;\npublic interface RewriteTest {\n    default String doesNotExist() {\n        return null;\n    }\n}"})).build().apply(new Cursor(this.getCursor(), arg), arg.getCoordinates().replace(), new Object[0]);
                            return doesNotExist.withPrefix(arg.getPrefix());
                        }
                        return arg;
                    }));
                }
                return mi;
            }
        });
    }
}

