/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.trait.Literal;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParseError;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.tree.Yaml;
import org.yaml.snakeyaml.Yaml;

public class ExamplesExtractor
extends ScanningRecipe<Accumulator> {
    private static final String DOCUMENT_EXAMPLE = "org.openrewrite.DocumentExample";
    private static final AnnotationMatcher DOCUMENT_EXAMPLE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.openrewrite.DocumentExample");
    private static final MethodMatcher DEFAULTS_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.RewriteTest defaults(org.openrewrite.test.RecipeSpec)", true);
    private static final MethodMatcher REWRITE_RUN_METHOD_MATCHER_WITH_SPEC = new MethodMatcher("org.openrewrite.test.RewriteTest rewriteRun(java.util.function.Consumer, org.openrewrite.test.SourceSpecs[])");
    private static final MethodMatcher REWRITE_RUN_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.RewriteTest rewriteRun(org.openrewrite.test.SourceSpecs[])");
    private static final MethodMatcher ASSERTIONS_METHOD_MATCHER = new MethodMatcher("org.openrewrite.*.Assertions *(..)");
    private static final MethodMatcher BUILD_GRADLE_METHOD_MATCHER = new MethodMatcher("org.openrewrite.gradle.Assertions buildGradle(..)");
    private static final MethodMatcher POM_XML_METHOD_MATCHER = new MethodMatcher("org.openrewrite.maven.Assertions pomXml(..)");
    private static final MethodMatcher ACTIVE_RECIPES_METHOD_MATCHER = new MethodMatcher("org.openrewrite.config.Environment activateRecipes(..)");
    private static final MethodMatcher RECIPE_FROM_RESOURCES_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.RecipeSpec#recipeFromResource*(..)");
    private static final MethodMatcher PATH_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.SourceSpec path(java.lang.String)");
    private static final MethodMatcher RECIPE_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.RecipeSpec#recipe*(..)");

    public String getDisplayName() {
        return "Extract documentation examples from tests";
    }

    public String getDescription() {
        return "Extract the before/after sources from tests annotated with `@DocumentExample`, and generate a YAML file with those examples to be shown in the documentation to show usage.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        final TreeVisitor examplesExtractorVisitor = Preconditions.check((TreeVisitor)new UsesType(DOCUMENT_EXAMPLE, Boolean.valueOf(false)), (TreeVisitor)new ExamplesExtractorVisitor(acc));
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (tree instanceof JavaSourceFile) {
                    examplesExtractorVisitor.visit(tree, (Object)ctx);
                } else if (tree instanceof Yaml.Documents) {
                    new YamlIsoVisitor<ExecutionContext>(){

                        public Yaml.Documents visitDocuments(Yaml.Documents documents, ExecutionContext ctx) {
                            Path sourcePath = documents.getSourcePath();
                            if (sourcePath.endsWith("examples.yml")) {
                                acc.existingExampleFiles.add(sourcePath);
                            }
                            return documents;
                        }
                    }.visit(tree, (Object)ctx);
                } else if (tree instanceof PlainText && ((PlainText)tree).getSourcePath().endsWith("licenseHeader.txt")) {
                    acc.licenseHeader = ((PlainText)tree).getText();
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        Yaml.Documents emptyDoc = YamlParser.builder().build().parse(new String[]{"---\n"}).filter(sf -> sf instanceof Yaml.Documents).map(sf -> (Yaml.Documents)sf).findFirst().get();
        return acc.projectRecipeExamples.entrySet().stream().filter(entry -> !acc.existingExampleFiles.contains(entry.getKey())).filter(entry -> !((Map)entry.getValue()).isEmpty()).map(entry -> emptyDoc.withSourcePath((Path)entry.getKey())).map(doc -> doc.withId(Tree.randomId())).collect(Collectors.toList());
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Documents visitDocuments(Yaml.Documents existingDocuments, ExecutionContext ctx) {
                Map<String, List<RecipeExample>> recipeExamples = acc.projectRecipeExamples.get(existingDocuments.getSourcePath());
                if (recipeExamples == null || recipeExamples.isEmpty()) {
                    return existingDocuments;
                }
                String yaml = new YamlPrinter().print(acc.licenseHeader, recipeExamples);
                List yamlDocuments = YamlParser.builder().build().parse(new String[]{yaml}).collect(Collectors.toList());
                if (yamlDocuments.isEmpty()) {
                    return existingDocuments;
                }
                SourceFile first = (SourceFile)yamlDocuments.get(0);
                if (first instanceof ParseError) {
                    return existingDocuments.withMarkers(first.getMarkers());
                }
                if (first instanceof Yaml.Documents && !first.printAll().equals(existingDocuments.printAll())) {
                    return existingDocuments.withDocuments(((Yaml.Documents)first).getDocuments());
                }
                return existingDocuments;
            }
        };
    }

    public static class Accumulator {
        @Nullable String licenseHeader;
        final List<Path> existingExampleFiles = new ArrayList<Path>();
        final Map<Path, Map<String, List<RecipeExample>>> projectRecipeExamples = new HashMap<Path, Map<String, List<RecipeExample>>>();
    }

    static class ExamplesExtractorVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String RECIPE_KEY = "recipeName";
        private static final String DESCRIPTION_KEY = "description";
        private final Accumulator acc;

        public ExamplesExtractorVisitor(Accumulator acc) {
            this.acc = acc;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            if (DEFAULTS_METHOD_MATCHER.matches(method.getMethodType())) {
                this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, RECIPE_KEY, (Object)this.findRecipe((J)method));
                return method;
            }
            Optional annotated = new Annotated.Matcher(DOCUMENT_EXAMPLE_ANNOTATION_MATCHER).lower(this.getCursor()).findAny();
            if (annotated.isPresent()) {
                String exampleDescription = ((Annotated)annotated.get()).getDefaultAttribute("value").map(Literal::getString).orElseGet(() -> String.format("`%s#%s`", ((J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class)).getSimpleName(), method.getSimpleName()));
                this.getCursor().putMessageOnFirstEnclosing(J.MethodDeclaration.class, DESCRIPTION_KEY, (Object)exampleDescription);
                return super.visitMethodDeclaration(method, (Object)ctx);
            }
            return method;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            int sourceStartIndex;
            List args = method.getArguments();
            if (REWRITE_RUN_METHOD_MATCHER_WITH_SPEC.matches((MethodCall)method)) {
                this.getCursor().putMessage(RECIPE_KEY, (Object)this.findRecipe((J)args.get(0)));
                sourceStartIndex = 1;
            } else if (REWRITE_RUN_METHOD_MATCHER.matches((MethodCall)method)) {
                sourceStartIndex = 0;
            } else {
                return method;
            }
            RecipeNameAndParameters recipe = (RecipeNameAndParameters)this.getCursor().getNearestMessage(RECIPE_KEY);
            if (recipe == null) {
                return method;
            }
            String exampleDescription = (String)this.getCursor().getNearestMessage(DESCRIPTION_KEY);
            RecipeExample example = new RecipeExample();
            List<Expression> sourceArgs = args.subList(sourceStartIndex, args.size());
            example.setSources(this.extractRecipeExampleSources(sourceArgs));
            if (!example.getSources().isEmpty()) {
                example.setDescription(exampleDescription);
                example.setParameters(recipe.parameters);
                String testSourcePath = ((J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class)).getSourcePath().toString();
                String root = testSourcePath.substring(0, testSourcePath.indexOf("src/"));
                Path targetPath = Paths.get(root, new String[0]).resolve("src/main/resources/META-INF/rewrite/examples.yml");
                this.acc.projectRecipeExamples.computeIfAbsent(targetPath, key -> new TreeMap()).computeIfAbsent(recipe.name, key -> new ArrayList()).add(example);
            }
            return method;
        }

        private @Nullable RecipeNameAndParameters findRecipe(final J tree) {
            return (RecipeNameAndParameters)((AtomicReference)new JavaIsoVisitor<AtomicReference<RecipeNameAndParameters>>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicReference<RecipeNameAndParameters> recipe) {
                    if (RECIPE_METHOD_MATCHER.matches((MethodCall)method)) {
                        new JavaIsoVisitor<AtomicReference<RecipeNameAndParameters>>(){

                            public J.NewClass visitNewClass(J.NewClass newClass, AtomicReference<RecipeNameAndParameters> recipe) {
                                JavaType type;
                                JavaType javaType = type = newClass.getClazz() != null ? newClass.getClazz().getType() : null;
                                if (type == null) {
                                    type = newClass.getType();
                                }
                                if (TypeUtils.isAssignableTo((String)"org.openrewrite.Recipe", (JavaType)type) && type instanceof JavaType.Class) {
                                    JavaType.Class tc = (JavaType.Class)type;
                                    RecipeNameAndParameters recipeNameAndParameters = new RecipeNameAndParameters();
                                    recipeNameAndParameters.name = tc.getFullyQualifiedName();
                                    recipeNameAndParameters.parameters = this.extractParameters(newClass.getArguments());
                                    recipe.set(recipeNameAndParameters);
                                }
                                return newClass;
                            }

                            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicReference<RecipeNameAndParameters> recipe) {
                                if (ACTIVE_RECIPES_METHOD_MATCHER.matches((MethodCall)method)) {
                                    Expression arg = (Expression)method.getArguments().get(0);
                                    if (arg instanceof J.Literal && ((J.Literal)arg).getValue() != null) {
                                        RecipeNameAndParameters recipeNameAndParameters = new RecipeNameAndParameters();
                                        recipeNameAndParameters.name = ((J.Literal)arg).getValue().toString();
                                        recipe.set(recipeNameAndParameters);
                                    }
                                    return method;
                                }
                                if (RECIPE_FROM_RESOURCES_METHOD_MATCHER.matches((MethodCall)method)) {
                                    Expression arg = (Expression)method.getArguments().get(method.getArguments().size() - 1);
                                    if (arg instanceof J.Literal && ((J.Literal)arg).getValue() != null) {
                                        RecipeNameAndParameters recipeNameAndParameters = new RecipeNameAndParameters();
                                        recipeNameAndParameters.name = ((J.Literal)arg).getValue().toString();
                                        recipe.set(recipeNameAndParameters);
                                    }
                                    return method;
                                }
                                return super.visitMethodInvocation(method, recipe);
                            }
                        }.visit((Tree)tree, recipe);
                    }
                    return super.visitMethodInvocation(method, recipe);
                }
            }.reduce((Tree)tree, new AtomicReference())).get();
        }

        private List<String> extractParameters(List<Expression> args) {
            return args.stream().map(arg -> {
                if (arg instanceof J.Empty) {
                    return null;
                }
                if (arg instanceof J.Literal) {
                    J.Literal literal = (J.Literal)arg;
                    if (literal.getValue() != null) {
                        return literal.getValue().toString();
                    }
                    return ((J.Literal)arg).getValueSource();
                }
                if (arg instanceof J.NewArray) {
                    List initializer = ((J.NewArray)arg).getInitializer();
                    return null == initializer ? "null" : this.extractParameters(initializer).stream().collect(Collectors.joining(", ", "[ ", " ]"));
                }
                return arg.toString();
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private List<RecipeExample.Source> extractRecipeExampleSources(List<Expression> sourceSpecArg) {
            JavaIsoVisitor<Set<RecipeExample.Source>> visitor = new JavaIsoVisitor<Set<RecipeExample.Source>>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Set<RecipeExample.Source> sources) {
                    J.Literal after;
                    J.Literal before;
                    String language;
                    method = super.visitMethodInvocation(method, sources);
                    RecipeExample.Source source = new RecipeExample.Source("", null, null, "");
                    if (BUILD_GRADLE_METHOD_MATCHER.matches((MethodCall)method)) {
                        source.setPath("build.gradle");
                        language = "groovy";
                    } else if (POM_XML_METHOD_MATCHER.matches((MethodCall)method)) {
                        source.setPath("pom.xml");
                        language = "xml";
                    } else if (ASSERTIONS_METHOD_MATCHER.matches((MethodCall)method)) {
                        language = method.getSimpleName();
                    } else {
                        return method;
                    }
                    source.setLanguage(language);
                    List args = method.getArguments();
                    J.Literal literal = !args.isEmpty() ? (((Expression)args.get(0)).getType() == JavaType.Primitive.String ? (J.Literal)args.get(0) : null) : (before = null);
                    J.Literal literal2 = args.size() > 1 ? (((Expression)args.get(1)).getType() == JavaType.Primitive.String ? (J.Literal)args.get(1) : null) : (after = null);
                    if (before != null && before.getValue() != null) {
                        source.setBefore((String)before.getValue());
                    }
                    if (after != null) {
                        source.setAfter((String)after.getValue());
                    }
                    Expression sourceSpec = (Expression)args.get(args.size() - 1);
                    if (args.size() > 1 && TypeUtils.isAssignableTo((String)"java.util.function.Consumer", (JavaType)sourceSpec.getType())) {
                        new JavaIsoVisitor<RecipeExample.Source>(){

                            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, RecipeExample.Source source) {
                                if (PATH_METHOD_MATCHER.matches((MethodCall)method) && method.getArguments().get(0) instanceof J.Literal) {
                                    source.setPath((String)((J.Literal)method.getArguments().get(0)).getValue());
                                }
                                return method;
                            }
                        }.visit((Tree)sourceSpec, (Object)source);
                    }
                    if (StringUtils.isNotEmpty((String)source.getBefore()) || StringUtils.isNotEmpty((String)source.getAfter())) {
                        sources.add(source);
                    }
                    return method;
                }
            };
            Set sortedSet = (Set)visitor.reduce(sourceSpecArg, new TreeSet<RecipeExample.Source>(Comparator.comparing(RecipeExample.Source::getLanguage).thenComparing(RecipeExample.Source::getBefore)));
            return new ArrayList<RecipeExample.Source>(sortedSet);
        }

        private static class RecipeNameAndParameters {
            String name = "";
            List<String> parameters = new ArrayList<String>();

            private RecipeNameAndParameters() {
            }
        }
    }

    static class YamlPrinter {
        private final Yaml yaml = new Yaml();

        YamlPrinter() {
        }

        String print(@Nullable String licenseHeader, Map<String, List<RecipeExample>> recipeExamples) {
            StringWriter stringWriter = new StringWriter();
            if (StringUtils.isNotEmpty((String)licenseHeader)) {
                boolean singleLine = !licenseHeader.trim().contains("\n");
                stringWriter.append(singleLine ? "#\n# " : "# ").append(licenseHeader.trim().replace("${year}", "2025").replace("\n", "\n# ").trim()).append(singleLine ? "\n#\n\n" : "\n");
            }
            for (Map.Entry<String, List<RecipeExample>> recipeEntry : recipeExamples.entrySet()) {
                Map<String, Object> yamlDoc = this.print(recipeEntry.getKey(), recipeEntry.getValue());
                stringWriter.append("---\n").append(this.yaml.dumpAsMap(yamlDoc));
            }
            return stringWriter.toString();
        }

        private Map<String, Object> print(String recipeName, List<RecipeExample> examples) {
            LinkedHashMap<String, Object> yamlDoc = new LinkedHashMap<String, Object>();
            yamlDoc.put("type", "specs.openrewrite.org/v1beta/example");
            yamlDoc.put("recipeName", recipeName);
            ArrayList examplesData = new ArrayList();
            yamlDoc.put("examples", examplesData);
            for (RecipeExample example : examples) {
                LinkedHashMap<String, Object> exampleData = new LinkedHashMap<String, Object>();
                example.getDescription();
                exampleData.put("description", example.getDescription());
                List params = example.getParameters();
                if (!params.isEmpty()) {
                    exampleData.put("parameters", params);
                }
                ArrayList sourcesData = new ArrayList();
                for (RecipeExample.Source source : example.getSources()) {
                    LinkedHashMap<String, String> sourceData = new LinkedHashMap<String, String>();
                    if (StringUtils.isNotEmpty((String)source.getBefore())) {
                        sourceData.put("before", source.getBefore());
                    }
                    if (StringUtils.isNotEmpty((String)source.getAfter())) {
                        sourceData.put("after", source.getAfter());
                    }
                    if (StringUtils.isNotEmpty((String)source.getPath())) {
                        sourceData.put("path", PathUtils.separatorsToUnix((String)source.getPath()));
                    }
                    if (StringUtils.isNotEmpty((String)source.getLanguage())) {
                        sourceData.put("language", source.getLanguage());
                    }
                    sourcesData.add(sourceData);
                }
                exampleData.put("sources", sourcesData);
                examplesData.add(exampleData);
            }
            return yamlDoc;
        }
    }
}

