/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public final class ExecutionContextParameterName
extends Recipe {
    @Option(displayName="Parameter name", description="The name or prefix to use for the `ExecutionContext` parameter.", example="ctx", required=false)
    private final @Nullable String parameterName;

    public String getDisplayName() {
        return "Use a standard name for `ExecutionContext`";
    }

    public String getDescription() {
        return "Visitors that are parameterized with `ExecutionContext` should use the parameter name `ctx`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String prefix = Optional.ofNullable(this.parameterName).orElse("ctx");
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.Recipe", Boolean.valueOf(false)), new UsesType("org.openrewrite.Visitor", Boolean.valueOf(false))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                for (Statement parameter : m.getParameters()) {
                    J.VariableDeclarations param;
                    if (!(parameter instanceof J.VariableDeclarations) || !TypeUtils.isOfClassType((JavaType)(param = (J.VariableDeclarations)parameter).getType(), (String)"org.openrewrite.ExecutionContext") || ((J.VariableDeclarations.NamedVariable)param.getVariables().get(0)).getSimpleName().startsWith(prefix)) continue;
                    m = (J.MethodDeclaration)new RenameVariable((J.VariableDeclarations.NamedVariable)param.getVariables().get(0), prefix).visitNonNull((Tree)m, (Object)ctx);
                }
                return m;
            }
        });
    }

    @Generated
    public ExecutionContextParameterName(@Nullable String parameterName) {
        this.parameterName = parameterName;
    }

    @Generated
    public @Nullable String getParameterName() {
        return this.parameterName;
    }

    @Generated
    public String toString() {
        return "ExecutionContextParameterName(parameterName=" + this.getParameterName() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionContextParameterName)) {
            return false;
        }
        ExecutionContextParameterName other = (ExecutionContextParameterName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$parameterName = this.getParameterName();
        String other$parameterName = other.getParameterName();
        return !(this$parameterName == null ? other$parameterName != null : !this$parameterName.equals(other$parameterName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionContextParameterName;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parameterName = this.getParameterName();
        result = result * 59 + ($parameterName == null ? 43 : $parameterName.hashCode());
        return result;
    }
}

