/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class NoMutableStaticFieldsInRecipes
extends Recipe {
    public String getDisplayName() {
        return "Recipe classes should not have mutable `static` fields";
    }

    public String getDescription() {
        return "Remove mutable static fields from Recipe classes to discourage their use.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.openrewrite.Recipe", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (TypeUtils.isAssignableTo((String)"org.openrewrite.Recipe", (JavaType)cd.getType())) {
                    return cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), stmt -> {
                        J.VariableDeclarations field;
                        if (stmt instanceof J.VariableDeclarations && (field = (J.VariableDeclarations)stmt).hasModifier(J.Modifier.Type.Static) && !field.hasModifier(J.Modifier.Type.Final) && FindAnnotations.find((J)field, (String)"@java.lang.SuppressWarnings").isEmpty()) {
                            return null;
                        }
                        return stmt;
                    })));
                }
                return cd;
            }
        });
    }
}

