/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class SourceSpecTextBlockNewLine
extends Recipe {
    public String getDisplayName() {
        return "New line at the end of `SourceSpecs` text blocks";
    }

    public String getDescription() {
        return "Text blocks that assert before and after source code should have a new line after it is closed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final Pattern endTextBlockOnOwnLine = Pattern.compile("\\s+\"\"\"\\s*$");

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (method.getMethodType() != null && TypeUtils.isOfClassType((JavaType)method.getMethodType().getReturnType(), (String)"org.openrewrite.test.SourceSpecs")) {
                    J.MethodInvocation.Padding methodPadding = method.getPadding();
                    JContainer arguments = methodPadding.getArguments();
                    JContainer.Padding argumentsPadding = arguments.getPadding();
                    List elements = argumentsPadding.getElements();
                    List formattedElements = ListUtils.map((List)elements, (i, jrp) -> {
                        boolean isPreviousTextBlock;
                        Expression argument = (Expression)jrp.getElement();
                        boolean isCurrentTextBlock = this.isTextBlock(argument);
                        boolean bl = isPreviousTextBlock = i > 0 && this.isTextBlock((Expression)((JRightPadded)elements.get(i - 1)).getElement());
                        if ((isCurrentTextBlock || isPreviousTextBlock) && argument.getPrefix().getComments().isEmpty() && !argument.getPrefix().getWhitespace().startsWith("\n")) {
                            Expression formatted = (Expression)argument.withPrefix(Space.format((String)"\n"));
                            formatted = (Expression)this.maybeAutoFormat((J)argument, (J)formatted, ctx);
                            return jrp.withElement((Object)formatted);
                        }
                        return jrp;
                    });
                    formattedElements = ListUtils.mapLast((List)formattedElements, jrp -> {
                        if (jrp == null) {
                            return null;
                        }
                        Expression argument = (Expression)jrp.getElement();
                        if (this.isTextBlock(argument) && !jrp.getAfter().getWhitespace().startsWith("\n")) {
                            return jrp.withAfter(method.getPrefix().withComments(Collections.emptyList()));
                        }
                        return jrp;
                    });
                    return methodPadding.withArguments(argumentsPadding.withElements(formattedElements));
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            private boolean isTextBlock(Expression expression) {
                if (!(expression instanceof J.Literal)) {
                    return false;
                }
                J.Literal source = (J.Literal)expression;
                return source.getValueSource() != null && source.getValueSource().startsWith("\"\"\"") && this.endTextBlockOnOwnLine.matcher(source.getValueSource()).find();
            }
        };
    }
}

