/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class UseRewriteTestDefaults
extends Recipe {
    public String getDisplayName() {
        return "Refactor RewriteTest to use defaults method";
    }

    public String getDescription() {
        return "When all `rewriteRun` methods in a test class use the same RecipeSpec configuration, refactor to use the `defaults` method instead.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.openrewrite.test.RewriteTest", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher rewriteRunMatcher = new MethodMatcher("org.openrewrite.test.RewriteTest rewriteRun(..)");

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (!TypeUtils.isAssignableTo((String)"org.openrewrite.test.RewriteTest", (JavaType)cd.getType())) {
                    return cd;
                }
                boolean hasDefaultsMethod = cd.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).anyMatch(md -> "defaults".equals(md.getSimpleName()));
                if (hasDefaultsMethod) {
                    return cd;
                }
                List<RecipeSpecInfo> specInfos = this.collectRecipeSpecs(cd);
                if (!this.allSpecsAreIdentical(specInfos)) {
                    return cd;
                }
                this.maybeAddImport("org.openrewrite.test.RecipeSpec");
                cd = this.newlineBeforeFirstStatement(cd);
                cd = this.addDefaultsMethod(cd, specInfos.get(0));
                return this.removeSpecsFromRewriteRuns(cd, ctx);
            }

            private List<RecipeSpecInfo> collectRecipeSpecs(J.ClassDeclaration cd) {
                return (List)new JavaIsoVisitor<List<RecipeSpecInfo>>(){

                    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, List<RecipeSpecInfo> recipeSpecInfos) {
                        return classDecl;
                    }

                    public J.NewClass visitNewClass(J.NewClass newClass, List<RecipeSpecInfo> recipeSpecInfos) {
                        return newClass;
                    }

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<RecipeSpecInfo> specs) {
                        if (rewriteRunMatcher.matches((MethodCall)method)) {
                            if (!method.getArguments().isEmpty()) {
                                Expression firstArg = (Expression)method.getArguments().get(0);
                                if (firstArg instanceof J.Lambda) {
                                    specs.add(new RecipeSpecInfo((J.Lambda)firstArg, null));
                                } else if (firstArg instanceof J.MemberReference) {
                                    specs.add(new RecipeSpecInfo(null, (J.MemberReference)firstArg));
                                } else {
                                    specs.add(new RecipeSpecInfo(null, null));
                                }
                            } else {
                                specs.add(new RecipeSpecInfo(null, null));
                            }
                        }
                        return super.visitMethodInvocation(method, specs);
                    }
                }.reduce((Tree)cd.getBody(), new ArrayList());
            }

            private boolean allSpecsAreIdentical(List<RecipeSpecInfo> specs) {
                if (specs.size() < 2) {
                    return false;
                }
                RecipeSpecInfo first = specs.get(0);
                for (int i = 1; i < specs.size(); ++i) {
                    if (this.areSpecsIdentical(first, specs.get(i))) continue;
                    return false;
                }
                return true;
            }

            private boolean areSpecsIdentical(RecipeSpecInfo spec1, RecipeSpecInfo spec2) {
                if (spec1.lambda == null && spec2.lambda == null) {
                    return spec1.methodRef != null && SemanticallyEqual.areEqual((J)spec1.methodRef, (J)spec2.methodRef);
                }
                if (spec1.methodRef == null && spec2.methodRef == null) {
                    return spec1.lambda != null && SemanticallyEqual.areEqual((J)spec1.lambda, (J)spec2.lambda);
                }
                return false;
            }

            private J.ClassDeclaration newlineBeforeFirstStatement(J.ClassDeclaration cd) {
                return cd.withBody(cd.getBody().withStatements(ListUtils.mapFirst((List)cd.getBody().getStatements(), first -> (Statement)first.withPrefix(first.getPrefix().withWhitespace("\n" + first.getPrefix().getWhitespace())))));
            }

            private J.ClassDeclaration addDefaultsMethod(J.ClassDeclaration cd, RecipeSpecInfo specInfo) {
                if (specInfo.lambda != null) {
                    return (J.ClassDeclaration)JavaTemplate.builder((String)"@Override\npublic void defaults(RecipeSpec spec) {\n    #{any()}\n}").contextSensitive().imports(new String[]{"org.openrewrite.test.RecipeSpec"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build().apply(new Cursor(this.getCursor(), (Object)cd), cd.getBody().getCoordinates().firstStatement(), new Object[]{specInfo.lambda.getBody()});
                }
                if (specInfo.methodRef != null) {
                    String simpleName = specInfo.methodRef.getReference().getSimpleName();
                    return (J.ClassDeclaration)JavaTemplate.builder((String)("@Override\npublic void defaults(RecipeSpec spec) {\n    " + simpleName + "(spec);\n}")).contextSensitive().imports(new String[]{"org.openrewrite.test.RecipeSpec"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build().apply(new Cursor(this.getCursor(), (Object)cd), cd.getBody().getCoordinates().firstStatement(), new Object[0]);
                }
                return cd;
            }

            private J.ClassDeclaration removeSpecsFromRewriteRuns(J.ClassDeclaration cd, ExecutionContext ctx) {
                J.Block body = (J.Block)new JavaIsoVisitor<ExecutionContext>(){

                    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                        return classDecl;
                    }

                    public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                        return newClass;
                    }

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                        J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                        if (rewriteRunMatcher.matches((MethodCall)mi)) {
                            return mi.withArguments(ListUtils.mapFirst((List)mi.getArguments(), firstArg -> firstArg instanceof J.Lambda || firstArg instanceof J.MemberReference ? null : firstArg));
                        }
                        return mi;
                    }
                }.visitNonNull((Tree)cd.getBody(), (Object)ctx);
                return cd.withBody(body);
            }

            final class RecipeSpecInfo {
                private final // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable J.Lambda lambda;
                private final // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable J.MemberReference methodRef;

                @Generated
                public RecipeSpecInfo(// Could not load outer class - annotation placement on inner may be incorrect
                @Nullable J.Lambda lambda, J.MemberReference methodRef) {
                    this.lambda = lambda;
                    this.methodRef = methodRef;
                }

                @Generated
                public // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable J.Lambda getLambda() {
                    return this.lambda;
                }

                @Generated
                public // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable J.MemberReference getMethodRef() {
                    return this.methodRef;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RecipeSpecInfo)) {
                        return false;
                    }
                    RecipeSpecInfo other = (RecipeSpecInfo)o;
                    J.Lambda this$lambda = this.getLambda();
                    J.Lambda other$lambda = other.getLambda();
                    if (this$lambda == null ? other$lambda != null : !this$lambda.equals(other$lambda)) {
                        return false;
                    }
                    J.MemberReference this$methodRef = this.getMethodRef();
                    J.MemberReference other$methodRef = other.getMethodRef();
                    return !(this$methodRef == null ? other$methodRef != null : !this$methodRef.equals(other$methodRef));
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    J.Lambda $lambda = this.getLambda();
                    result = result * 59 + ($lambda == null ? 43 : $lambda.hashCode());
                    J.MemberReference $methodRef = this.getMethodRef();
                    result = result * 59 + ($methodRef == null ? 43 : $methodRef.hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "RecipeSpecInfo(lambda=" + this.getLambda() + ", methodRef=" + this.getMethodRef() + ")";
                }
            }
        });
    }
}

