/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class CorrectlySpacedDescriptions
extends Recipe {
    private static final String ENDS_WITH_LINEBREAK = "[\\s\\S]*\\n+\\s*$";
    private static final String IS_ONLY_WHITESPACE = "^\\s*$";
    private static final String IS_MAYBE_MD_LIST = "^\\s?[-*]\\s\\S[\\s\\S]*";
    private static final String IS_MAYBE_END_OF_MD_LINK = ".*]$";
    private static final MethodMatcher GET_DESCRIPTION_MATCHER = new MethodMatcher("org.openrewrite.Recipe getDescription()", true);

    public String getDisplayName() {
        return "Correctly spaced descriptions";
    }

    public String getDescription() {
        return "Recipe descriptions should be cleanly formatted. This recipe forces correct spacing in multiline descriptions. In a multi line description the lines should not start with whitespace and end with a single space except for the last line which should end with a \".\" (e.g.\n  ```return \"This is a correct \" + \n   \"multi line description\";```).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> visitor = new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (GET_DESCRIPTION_MATCHER.matches(method.getMethodType())) {
                    return (J.MethodDeclaration)new JavaIsoVisitor<ExecutionContext>(){

                        public J.Binary visitBinary(J.Binary binary, ExecutionContext ctx) {
                            J.Binary b = super.visitBinary(binary, (Object)ctx);
                            if (b.getLeft() instanceof J.Literal) {
                                b = this.maybeFormatLeftPrefix(b);
                            }
                            b = this.maybeFormatLeftSuffix(b);
                            b = this.maybeFormatRightPrefix(b);
                            if (this.getCursor().getParentTreeCursor().getValue() instanceof J.Return) {
                                b = this.maybeFormatRightSuffix(b);
                            }
                            return b;
                        }
                    }.visitNonNull((Tree)method, (Object)ctx, this.getCursor().getParentOrThrow());
                }
                return super.visitMethodDeclaration(method, (Object)ctx);
            }

            private J.Binary maybeFormatLeftPrefix(J.Binary b) {
                return b.withLeft((Expression)this.maybeFormatLiteralPrefix((J.Literal)b.getLeft()));
            }

            private J.Binary maybeFormatLeftSuffix(J.Binary b) {
                J.Binary left;
                Expression right;
                if (b.getLeft() instanceof J.Literal && b.getRight() instanceof J.Literal) {
                    return b.withLeft((Expression)this.maybeFormatLiteralSuffix((J.Literal)b.getLeft()));
                }
                if (b.getLeft() instanceof J.Binary && b.getRight() instanceof J.Literal && (right = (left = (J.Binary)b.getLeft()).getRight()) instanceof J.Literal) {
                    return b.withLeft((Expression)left.withRight((Expression)this.maybeFormatLiteralSuffix((J.Literal)right)));
                }
                return b;
            }

            private J.Binary maybeFormatRightPrefix(J.Binary b) {
                if (b.getLeft() instanceof J.Literal || b.getLeft() instanceof J.Binary && ((J.Binary)b.getLeft()).getRight() instanceof J.Literal && b.getRight() instanceof J.Literal) {
                    return b.withRight((Expression)this.maybeFormatLiteralPrefix((J.Literal)b.getRight()));
                }
                return b;
            }

            private J.Binary maybeFormatRightSuffix(J.Binary b) {
                if (b.getRight() instanceof J.Literal) {
                    return b.withRight((Expression)this.maybeFormatLiteralSuffix((J.Literal)b.getRight(), true));
                }
                return b;
            }

            private J.Literal maybeFormatLiteralPrefix(J.Literal l) {
                if (l.getValue() instanceof String) {
                    String value = (String)l.getValue();
                    if (value.matches(CorrectlySpacedDescriptions.IS_ONLY_WHITESPACE)) {
                        return l;
                    }
                    if ((value = value.replaceAll("^\\h+", "")).matches(CorrectlySpacedDescriptions.IS_MAYBE_MD_LIST)) {
                        value = " " + value;
                    }
                    if (!value.equals(l.getValue())) {
                        String valueSource = value.replace("\"", "\\\"");
                        valueSource = valueSource.replaceAll("\\n", "\\\\n");
                        return l.withValue((Object)value).withValueSource("\"" + valueSource + "\"");
                    }
                }
                return l;
            }

            private J.Literal maybeFormatLiteralSuffix(J.Literal l) {
                return this.maybeFormatLiteralSuffix(l, false);
            }

            private J.Literal maybeFormatLiteralSuffix(J.Literal l, boolean isLastLine) {
                if (l.getValue() instanceof String) {
                    String value = (String)l.getValue();
                    if (value.matches(CorrectlySpacedDescriptions.IS_ONLY_WHITESPACE) || value.matches(CorrectlySpacedDescriptions.IS_MAYBE_END_OF_MD_LINK)) {
                        return l;
                    }
                    if (value.matches(CorrectlySpacedDescriptions.IS_MAYBE_MD_LIST)) {
                        if (value.matches(CorrectlySpacedDescriptions.ENDS_WITH_LINEBREAK)) {
                            value = value.substring(0, value.lastIndexOf("\n") + 1);
                        } else {
                            value = value.replaceAll("\\h*$", "");
                            value = value + (isLastLine ? "" : "\n");
                        }
                    } else if (value.matches(CorrectlySpacedDescriptions.ENDS_WITH_LINEBREAK)) {
                        value = value.substring(0, value.lastIndexOf("\n") + 1);
                    } else {
                        value = value.replaceAll("\\h*$", "");
                        value = value + (isLastLine ? "" : " ");
                    }
                    if (!value.equals(l.getValue())) {
                        String valueSource = value.replace("\"", "\\\"");
                        valueSource = valueSource.replaceAll("\\n", "\\\\n");
                        return l.withValue((Object)value).withValueSource("\"" + valueSource + "\"");
                    }
                }
                return l;
            }
        };
        return Preconditions.check((TreeVisitor)new DeclaresMethod(GET_DESCRIPTION_MATCHER), (TreeVisitor)visitor);
    }
}

