/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class BlankLinesAroundFieldsWithAnnotations
extends Recipe {
    public String getDisplayName() {
        return "Add a blank line around fields with annotations";
    }

    public String getDescription() {
        return "Fields with annotations should have a blank line before them to clearly separate them from the field above. If another field follows, it should also have a blank line after so that the field with the annotation has space on either side of it, visually distinguishing it from its neighbors.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (classDecl.getBody() != null) {
                    List statements = Objects.requireNonNull(cd).getBody().getStatements();
                    AtomicBoolean precedingFieldHadAnnotation = new AtomicBoolean();
                    cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)statements, (i, s) -> {
                        if (precedingFieldHadAnnotation.get()) {
                            precedingFieldHadAnnotation.set(false);
                            if (s instanceof J.VariableDeclarations) {
                                s = (Statement)s.withPrefix(s.getPrefix().withWhitespace(BlankLinesVisitor.minimumLines((String)s.getPrefix().getWhitespace(), (int)1)));
                            }
                        }
                        if (s instanceof J.VariableDeclarations) {
                            J.VariableDeclarations mv = (J.VariableDeclarations)s;
                            if (!mv.getLeadingAnnotations().isEmpty()) {
                                if (i > 0 && statements.get(i - 1) instanceof J.VariableDeclarations) {
                                    mv = mv.withPrefix(mv.getPrefix().withWhitespace(BlankLinesVisitor.minimumLines((String)mv.getPrefix().getWhitespace(), (int)1)));
                                }
                                precedingFieldHadAnnotation.set(true);
                            }
                            return mv;
                        }
                        return s;
                    })));
                }
                return cd;
            }
        };
    }
}

